/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.model.UnparsedTextList;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Long id;
    protected Integer sortKey;
    protected String name;
    protected String value;
    protected UnparsedTextList unparsedTexts = null;

    public Tag() {
    }

    public Tag(String inner) {
        Validate.notNull((Object)inner, (String)"parameter 'inner' cannot be null");
        int i = inner.indexOf(58);
        if (i >= 0) {
            if (i > 0) {
                this.name = inner.substring(0, i);
            }
            if (i + 1 < inner.length()) {
                this.value = inner.substring(i + 1);
            }
        } else if (inner.length() > 0) {
            this.value = inner;
        }
    }

    public Tag(String tagname, String value) {
        Validate.notNull((Object)tagname, (String)"parameter 'tagname' cannot be null");
        Validate.notNull((Object)value, (String)"parameter 'value' cannot be null");
        this.name = tagname;
        this.value = value;
    }

    public Tag(UnparsedTextList unparsedText) {
        this();
        this.unparsedTexts = unparsedText;
    }

    public Tag(String inner, UnparsedTextList unparsedText) {
        this(inner);
        this.unparsedTexts = unparsedText;
    }

    public Tag(String tagname, String value, UnparsedTextList unparsedText) {
        this(tagname, value);
        this.unparsedTexts = unparsedText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Validate.notNull((Object)name, (String)"parameter 'name' cannot be null");
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(Integer sortKey) {
        this.sortKey = sortKey;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sortKey == null ? 0 : this.sortKey.hashCode());
        result = 31 * result + (this.unparsedTexts == null ? 0 : this.unparsedTexts.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sortKey == null ? other.sortKey != null : !this.sortKey.equals(other.sortKey)) {
            return false;
        }
        if (this.unparsedTexts == null ? other.unparsedTexts != null : !this.unparsedTexts.equals(other.unparsedTexts)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int getNameAsInt() {
        try {
            return Integer.valueOf(this.name);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean isNumber(int i) {
        return this.name != null && this.name.startsWith("" + i);
    }

    public String getLetterOption() {
        if (this.name != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isLetter(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }
}

