/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.ssl.asn1.ASN1InputStream;
import org.apache.commons.ssl.asn1.ASN1OutputStream;
import org.apache.commons.ssl.asn1.DEREncodable;
import org.apache.commons.ssl.asn1.DERObject;

public class DERApplicationSpecific
extends DERObject {
    private int tag;

    public DERApplicationSpecific(int tag, byte[] value) {
        super(tag, value);
        this.tag = tag;
    }

    public static DERApplicationSpecific valueOf(int tag, DEREncodable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        aos.writeObject(object);
        return new DERApplicationSpecific(tag |= 0x20, baos.toByteArray());
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public DEREncodable getObject() throws IOException {
        return new ASN1InputStream(this.getOctets()).readObject();
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.value);
    }
}

