/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.LogWrapper;
import org.apache.commons.ssl.SSLClient;
import org.apache.commons.ssl.SSLServer;
import org.apache.commons.ssl.TrustMaterial;

public class RMISocketFactoryImpl
extends RMISocketFactory {
    public static final String LOCAL_INTERNET_FACING_ADDRESS;
    public static final String RMI_HOSTNAME_KEY = "java.rmi.server.hostname";
    private static final LogWrapper log;
    private volatile String localBindingAddress;
    private volatile SocketFactory defaultClient;
    private volatile ServerSocketFactory sslServer;
    private Map clientMap = new TreeMap();
    private Map serverSockets = new HashMap();
    private final SocketFactory plainClient = SocketFactory.getDefault();
    static /* synthetic */ Class class$org$apache$commons$ssl$RMISocketFactoryImpl;

    public RMISocketFactoryImpl() throws GeneralSecurityException, IOException {
        this.setServer(new SSLServer());
        this.setDefaultClient(new SSLClient());
    }

    public void setLocalBindingAddress(String ip) {
        this.localBindingAddress = ip;
    }

    public String getLocalBindingAddress() {
        return this.localBindingAddress;
    }

    public void setServer(ServerSocketFactory f) throws GeneralSecurityException, IOException {
        this.sslServer = f;
        this.trustOurself();
    }

    public void setDefaultClient(SocketFactory f) throws GeneralSecurityException, IOException {
        this.defaultClient = f;
        this.trustOurself();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClient(String host, SocketFactory f) throws GeneralSecurityException, IOException {
        if (f != null && this.sslServer != null) {
            boolean clientIsCommonsSSL = f instanceof SSLClient;
            boolean serverIsCommonsSSL = this.sslServer instanceof SSLServer;
            if (clientIsCommonsSSL && serverIsCommonsSSL) {
                SSLClient c = (SSLClient)f;
                SSLServer s = (SSLServer)this.sslServer;
                this.trustEachOther(c, s);
            }
        }
        Set names = this.hostnamePossibilities(host);
        Iterator it = names.iterator();
        RMISocketFactoryImpl rMISocketFactoryImpl = this;
        synchronized (rMISocketFactoryImpl) {
            while (it.hasNext()) {
                this.clientMap.put(it.next(), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(String host) {
        Set names = this.hostnamePossibilities(host);
        Iterator it = names.iterator();
        RMISocketFactoryImpl rMISocketFactoryImpl = this;
        synchronized (rMISocketFactoryImpl) {
            while (it.hasNext()) {
                this.clientMap.remove(it.next());
            }
        }
    }

    public synchronized void removeClient(SocketFactory sf) {
        Iterator it = this.clientMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object o = entry.getValue();
            if (!sf.equals(o)) continue;
            it.remove();
        }
    }

    private Set hostnamePossibilities(String host) {
        String name2;
        String name1;
        int i;
        InetAddress[] addresses;
        String string = host = host != null ? host.toLowerCase().trim() : "";
        if ("".equals(host)) {
            return Collections.EMPTY_SET;
        }
        TreeSet<String> names = new TreeSet<String>();
        names.add(host);
        try {
            addresses = InetAddress.getAllByName(host);
            for (i = 0; i < addresses.length; ++i) {
                name1 = addresses[i].getHostName();
                name2 = addresses[i].getHostAddress();
                names.add(name1.trim().toLowerCase());
                names.add(name2.trim().toLowerCase());
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        try {
            host = InetAddress.getByName(host).getHostAddress();
            host = InetAddress.getByName(host).getHostName();
            names.add(host.trim().toLowerCase());
            addresses = InetAddress.getAllByName(host);
            for (i = 0; i < addresses.length; ++i) {
                name1 = addresses[i].getHostName();
                name2 = addresses[i].getHostAddress();
                names.add(name1.trim().toLowerCase());
                names.add(name2.trim().toLowerCase());
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        return names;
    }

    private void trustOurself() throws GeneralSecurityException, IOException {
        if (this.defaultClient == null || this.sslServer == null) {
            return;
        }
        boolean clientIsCommonsSSL = this.defaultClient instanceof SSLClient;
        boolean serverIsCommonsSSL = this.sslServer instanceof SSLServer;
        if (clientIsCommonsSSL && serverIsCommonsSSL) {
            SSLClient c = (SSLClient)this.defaultClient;
            SSLServer s = (SSLServer)this.sslServer;
            this.trustEachOther(c, s);
        }
    }

    private void trustEachOther(SSLClient client, SSLServer server) throws GeneralSecurityException, IOException {
        if (client != null && server != null) {
            TrustMaterial tm;
            X509Certificate[] certs = server.getAssociatedCertificateChain();
            if (certs != null && certs[0] != null) {
                tm = new TrustMaterial(certs[0]);
                client.addTrustMaterial(tm);
            }
            if ((certs = client.getAssociatedCertificateChain()) != null && certs[0] != null) {
                tm = new TrustMaterial(certs[0]);
                server.addTrustMaterial(tm);
            }
        }
    }

    public ServerSocketFactory getServer() {
        return this.sslServer;
    }

    public SocketFactory getDefaultClient() {
        return this.defaultClient;
    }

    public synchronized SocketFactory getClient(String host) {
        host = host != null ? host.trim().toLowerCase() : "";
        return (SocketFactory)this.clientMap.get(host);
    }

    private void initLocalBindingAddress() {
        String systemRMIHostname = System.getProperty(RMI_HOSTNAME_KEY);
        if (this.localBindingAddress == null) {
            this.localBindingAddress = systemRMIHostname;
            if (this.localBindingAddress == null) {
                this.localBindingAddress = LOCAL_INTERNET_FACING_ADDRESS;
            }
        }
        if (systemRMIHostname == null && this.localBindingAddress != null) {
            System.setProperty(RMI_HOSTNAME_KEY, this.localBindingAddress);
        }
    }

    public synchronized ServerSocket createServerSocket(int port) throws IOException {
        this.initLocalBindingAddress();
        Integer key = new Integer(port);
        ServerSocket ss = (ServerSocket)this.serverSockets.get(key);
        if (ss == null) {
            log.debug("commons-ssl RMI server-socket: listening on port " + port);
            ss = this.sslServer.createServerSocket(port);
            this.serverSockets.put(key, ss);
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocket(String host, int port) throws IOException {
        boolean isPlain22;
        SSLSocket sSLSocket;
        Socket s;
        boolean tryPlain;
        Throwable reasonForPlainSocket;
        int soTimeout;
        SSLSocket ssl;
        SocketFactory sf;
        InetAddress local;
        block19: {
            host = host != null ? host.trim().toLowerCase() : "";
            this.initLocalBindingAddress();
            local = null;
            if (this.localBindingAddress != null) {
                local = InetAddress.getByName(this.localBindingAddress);
            }
            RMISocketFactoryImpl rMISocketFactoryImpl = this;
            synchronized (rMISocketFactoryImpl) {
                sf = (SocketFactory)this.clientMap.get(host);
            }
            if (sf == null) {
                sf = this.defaultClient;
            }
            ssl = null;
            soTimeout = Integer.MIN_VALUE;
            reasonForPlainSocket = null;
            tryPlain = false;
            s = sf.createSocket(host, port, local, 0);
            soTimeout = s.getSoTimeout();
            if (s instanceof SSLSocket) break block19;
            Socket socket = s;
            Object var14_16 = null;
            boolean isPlain22 = tryPlain || ssl == null;
            String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
            String localIP = local != null ? local.getHostAddress() : "ANY";
            StringBuffer buf = new StringBuffer(64);
            buf.append(socket2);
            buf.append(localIP);
            buf.append(" --> ");
            buf.append(host);
            buf.append(":");
            buf.append(port);
            log.debug(buf.toString());
            return socket;
        }
        try {
            ssl = (SSLSocket)s;
            ssl.setSoTimeout(15000);
            ssl.getSession().getPeerCertificates();
            ssl.setSoTimeout(soTimeout);
            sSLSocket = ssl;
            Object var14_17 = null;
            isPlain22 = tryPlain || ssl == null;
        }
        catch (IOException ioe) {
            boolean isPlain22;
            try {
                Throwable t;
                for (t = ioe; !tryPlain && t != null; t = t.getCause()) {
                    tryPlain = tryPlain || t instanceof EOFException;
                    tryPlain = tryPlain || t instanceof InterruptedIOException;
                    tryPlain = tryPlain || t instanceof SSLProtocolException;
                }
                if (!tryPlain && ioe instanceof SSLPeerUnverifiedException) {
                    try {
                        ssl.startHandshake();
                    }
                    catch (IOException ioe2) {
                        ioe = ioe2;
                        for (t = ioe2; !tryPlain && t != null; t = t.getCause()) {
                            tryPlain = tryPlain || t instanceof EOFException;
                            tryPlain = tryPlain || t instanceof InterruptedIOException;
                            tryPlain = tryPlain || t instanceof SSLProtocolException;
                        }
                    }
                }
                if (!tryPlain) {
                    throw ioe;
                }
                reasonForPlainSocket = ioe;
                Object var14_18 = null;
                isPlain22 = tryPlain || ssl == null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                boolean isPlain22 = tryPlain || ssl == null;
                String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
                String localIP = local != null ? local.getHostAddress() : "ANY";
                StringBuffer buf = new StringBuffer(64);
                buf.append(socket2);
                buf.append(localIP);
                buf.append(" --> ");
                buf.append(host);
                buf.append(":");
                buf.append(port);
                log.debug(buf.toString());
                throw throwable;
            }
            String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
            String localIP = local != null ? local.getHostAddress() : "ANY";
            StringBuffer buf = new StringBuffer(64);
            buf.append(socket2);
            buf.append(localIP);
            buf.append(" --> ");
            buf.append(host);
            buf.append(":");
            buf.append(port);
            log.debug(buf.toString());
            {
            }
        }
        String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
        String localIP = local != null ? local.getHostAddress() : "ANY";
        StringBuffer buf = new StringBuffer(64);
        buf.append(socket2);
        buf.append(localIP);
        buf.append(" --> ");
        buf.append(host);
        buf.append(":");
        buf.append(port);
        log.debug(buf.toString());
        return sSLSocket;
        sf = this.plainClient;
        s = JavaImpl.connect(null, sf, host, port, local, 0, 15000);
        if (soTimeout != Integer.MIN_VALUE) {
            s.setSoTimeout(soTimeout);
        }
        try {
            this.setClient(host, this.plainClient);
            String msg = "RMI downgrading from SSL to plain-socket for " + host + " because of " + reasonForPlainSocket;
            log.warn(msg, reasonForPlainSocket);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("can't happen because we're using plain socket", gse);
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        log = LogWrapper.getLogger(class$org$apache$commons$ssl$RMISocketFactoryImpl == null ? (class$org$apache$commons$ssl$RMISocketFactoryImpl = RMISocketFactoryImpl.class$("org.apache.commons.ssl.RMISocketFactoryImpl")) : class$org$apache$commons$ssl$RMISocketFactoryImpl);
        String google = "216.239.39.99";
        String ip = null;
        try {
            DatagramSocket dg = new DatagramSocket();
            dg.setSoTimeout(250);
            InetAddress addr = InetAddress.getByName(google);
            dg.connect(addr, 12345);
            ip = dg.getLocalAddress().getHostAddress();
            log.debug("Using bogus UDP socket (" + google + ":12345), I think my IP address is: " + ip);
            dg.close();
            if ("0.0.0.0".equals(ip)) {
                ip = null;
            }
        }
        catch (IOException ioe) {
            log.debug("Bogus UDP didn't work: " + ioe);
        }
        finally {
            LOCAL_INTERNET_FACING_ADDRESS = ip;
        }
    }
}

