/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.server.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.hornetq.core.protocol.stomp.StompProtocolManagerFactory;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.remoting.impl.netty.TransportConstants;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.AcceptorFactory;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.HornetQThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingServiceImpl
implements RemotingService,
ConnectionLifeCycleListener {
    private static final Logger log = Logger.getLogger(RemotingServiceImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    public static final long CONNECTION_TTL_CHECK_INTERVAL = 2000L;
    private volatile boolean started = false;
    private final Set<TransportConfiguration> acceptorsConfig;
    private final List<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
    private final Set<Acceptor> acceptors = new HashSet<Acceptor>();
    private final Map<Object, ConnectionEntry> connections = new ConcurrentHashMap<Object, ConnectionEntry>();
    private final Configuration config;
    private final HornetQServer server;
    private final ManagementService managementService;
    private volatile RemotingConnection serverSideReplicatingConnection;
    private ExecutorService threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private FailureCheckAndFlushThread failureCheckAndFlushThread;
    private final ClusterManager clusterManager;
    private Map<ProtocolType, ProtocolManager> protocolMap = new ConcurrentHashMap<ProtocolType, ProtocolManager>();

    public RemotingServiceImpl(ClusterManager clusterManager, Configuration config, HornetQServer server, ManagementService managementService, ScheduledExecutorService scheduledThreadPool) {
        this.acceptorsConfig = config.getAcceptorConfigurations();
        this.server = server;
        this.clusterManager = clusterManager;
        for (String interceptorClass : config.getInterceptorClassNames()) {
            try {
                this.interceptors.add((Interceptor)RemotingServiceImpl.safeInitNewInstance(interceptorClass));
            }
            catch (Exception e) {
                log.warn("Error instantiating interceptor \"" + interceptorClass + "\"", e);
            }
        }
        this.config = config;
        this.managementService = managementService;
        this.scheduledThreadPool = scheduledThreadPool;
        this.protocolMap.put(ProtocolType.CORE, new CoreProtocolManagerFactory().createProtocolManager(server, this.interceptors));
        this.protocolMap.put(ProtocolType.STOMP, new StompProtocolManagerFactory().createProtocolManager(server, this.interceptors));
        this.protocolMap.put(ProtocolType.STOMP_WS, new StompProtocolManagerFactory().createProtocolManager(server, this.interceptors));
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        HornetQThreadFactory tFactory = new HornetQThreadFactory("HornetQ-remoting-threads-" + this.server.toString() + "-" + System.identityHashCode(this), false, tccl);
        this.threadPool = Executors.newCachedThreadPool(tFactory);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (TransportConfiguration info : this.acceptorsConfig) {
            try {
                Set<String> invalid;
                Class<?> clazz = loader.loadClass(info.getFactoryClassName());
                AcceptorFactory factory = (AcceptorFactory)clazz.newInstance();
                if (info.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), info.getParams().keySet())).isEmpty()) {
                    log.warn(ConfigurationHelper.stringSetToCommaListString("The following keys are invalid for configuring the acceptor: ", invalid) + " the acceptor will not be started.");
                    continue;
                }
                String protocolString = ConfigurationHelper.getStringProperty("protocol", TransportConstants.DEFAULT_PROTOCOL, info.getParams());
                ProtocolType protocol = ProtocolType.valueOf(protocolString.toUpperCase());
                ProtocolManager manager = this.protocolMap.get((Object)protocol);
                ClusterConnection clusterConnection = this.lookupClusterConnection(info);
                Acceptor acceptor = factory.createAcceptor(clusterConnection, info.getParams(), new DelegatingBufferHandler(), manager, this, this.threadPool, this.scheduledThreadPool);
                this.acceptors.add(acceptor);
                if (this.managementService == null) continue;
                acceptor.setNotificationService((NotificationService)this.managementService);
                this.managementService.registerAcceptor(acceptor, info);
            }
            catch (Exception e) {
                log.warn("Error instantiating acceptor \"" + info.getFactoryClassName() + "\"", e);
            }
        }
        for (Acceptor a : this.acceptors) {
            a.start();
        }
        this.failureCheckAndFlushThread = new FailureCheckAndFlushThread(2000L);
        this.failureCheckAndFlushThread.start();
        this.started = true;
    }

    @Override
    public synchronized void freeze() {
        for (Acceptor acceptor : this.acceptors) {
            try {
                acceptor.pause();
            }
            catch (Exception e) {
                log.error("Failed to stop acceptor", e);
            }
        }
    }

    @Override
    public void stop(boolean criticalError) throws Exception {
        boolean ok;
        if (!this.started) {
            return;
        }
        if (!this.started) {
            return;
        }
        this.failureCheckAndFlushThread.close(criticalError);
        for (Acceptor acceptor : this.acceptors) {
            if (log.isDebugEnabled()) {
                log.debug("Pausing acceptor " + acceptor);
            }
            acceptor.pause();
        }
        if (log.isDebugEnabled()) {
            log.debug("Sending disconnect on live connections");
        }
        HashSet<ConnectionEntry> connectionEntries = new HashSet<ConnectionEntry>();
        connectionEntries.addAll(this.connections.values());
        for (ConnectionEntry entry : connectionEntries) {
            RemotingConnection conn = entry.connection;
            if (log.isTraceEnabled()) {
                log.trace("Sending connection.disconnection packet to " + conn);
            }
            conn.disconnect(criticalError);
        }
        for (Acceptor acceptor : this.acceptors) {
            acceptor.stop();
        }
        this.acceptors.clear();
        this.connections.clear();
        if (this.managementService != null) {
            this.managementService.unregisterAcceptors();
        }
        this.threadPool.shutdown();
        if (!criticalError && !(ok = this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS))) {
            log.warn("Timed out waiting for remoting thread pool to terminate");
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public RemotingConnection removeConnection(Object remotingConnectionID) {
        ConnectionEntry entry = this.connections.remove(remotingConnectionID);
        if (entry != null) {
            return entry.connection;
        }
        log.info("failed to remove connection");
        return null;
    }

    @Override
    public synchronized Set<RemotingConnection> getConnections() {
        HashSet<RemotingConnection> conns = new HashSet<RemotingConnection>();
        for (ConnectionEntry entry : this.connections.values()) {
            conns.add(entry.connection);
        }
        return conns;
    }

    @Override
    public RemotingConnection getServerSideReplicatingConnection() {
        return this.serverSideReplicatingConnection;
    }

    private ProtocolManager getProtocolManager(ProtocolType protocol) {
        return this.protocolMap.get((Object)protocol);
    }

    @Override
    public void connectionCreated(Acceptor acceptor, Connection connection, ProtocolType protocol) {
        if (this.server == null) {
            throw new IllegalStateException("Unable to create connection, server hasn't finished starting up");
        }
        ProtocolManager pmgr = this.getProtocolManager(protocol);
        if (pmgr == null) {
            throw new IllegalArgumentException("Unknown protocol " + (Object)((Object)protocol));
        }
        ConnectionEntry entry = pmgr.createConnectionEntry(acceptor, connection);
        if (isTrace) {
            log.trace("Connection created " + connection);
        }
        this.connections.put(connection.getID(), entry);
        if (this.config.isBackup()) {
            this.serverSideReplicatingConnection = entry.connection;
        }
    }

    @Override
    public void connectionDestroyed(Object connectionID) {
        ConnectionEntry conn;
        if (isTrace) {
            log.trace("Connection removed " + connectionID + " from server " + this.server, new Exception("trace"));
        }
        if ((conn = this.connections.get(connectionID)) != null) {
            List<FailureListener> failureListeners = conn.connection.getFailureListeners();
            boolean empty = true;
            for (FailureListener listener : failureListeners) {
                if (!(listener instanceof ServerSessionImpl)) continue;
                empty = false;
                break;
            }
            if (empty) {
                this.connections.remove(connectionID);
                conn.connection.destroy();
            }
        }
    }

    @Override
    public void connectionException(Object connectionID, HornetQException me) {
    }

    @Override
    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    private ClusterConnection lookupClusterConnection(TransportConfiguration acceptorConfig) {
        String clusterConnectionName = (String)acceptorConfig.getParams().get("cluster-connection");
        ClusterConnection clusterConnection = null;
        if (clusterConnectionName != null) {
            clusterConnection = this.clusterManager.getClusterConnection(clusterConnectionName);
        }
        if (clusterConnection == null) {
            clusterConnection = this.clusterManager.getDefaultConnection(acceptorConfig);
        }
        return clusterConnection;
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ClassLoader loader = this.getClass().getClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    return clazz.newInstance();
                }
                catch (Throwable t) {
                    try {
                        loader = Thread.currentThread().getContextClassLoader();
                        if (loader != null) {
                            return loader.loadClass(className).newInstance();
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IllegalArgumentException("Could not find class " + className);
                }
            }
        });
    }

    private final class FailureCheckAndFlushThread
    extends Thread {
        private final long pauseInterval;
        private volatile boolean closed;

        FailureCheckAndFlushThread(long pauseInterval) {
            super("hornetq-failure-check-thread");
            this.pauseInterval = pauseInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean criticalError) {
            this.closed = true;
            FailureCheckAndFlushThread failureCheckAndFlushThread = this;
            synchronized (failureCheckAndFlushThread) {
                this.notify();
            }
            if (!criticalError) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.closed) {
                try {
                    RemotingConnection conn;
                    long now = System.currentTimeMillis();
                    HashSet<Object> idsToRemove = new HashSet<Object>();
                    for (ConnectionEntry entry : RemotingServiceImpl.this.connections.values()) {
                        conn = entry.connection;
                        boolean flush = true;
                        if (entry.ttl != -1L && now >= entry.lastCheck + entry.ttl) {
                            if (!conn.checkDataReceived()) {
                                idsToRemove.add(conn.getID());
                                flush = false;
                            } else {
                                entry.lastCheck = now;
                            }
                        }
                        if (!flush) continue;
                        conn.flush();
                    }
                    for (Object id : idsToRemove) {
                        conn = RemotingServiceImpl.this.removeConnection(id);
                        if (conn == null) continue;
                        HornetQException me = new HornetQException(3, "Did not receive data from " + conn.getRemoteAddress() + ". It is likely the client has exited or crashed without " + "closing its connection, or the network between the server and client has failed. " + "You also might have configured connection-ttl and client-failure-check-period incorrectly. " + "Please check user manual for more information." + " The connection will now be closed.");
                        conn.fail(me);
                    }
                    FailureCheckAndFlushThread failureCheckAndFlushThread = this;
                    synchronized (failureCheckAndFlushThread) {
                        long start = System.currentTimeMillis();
                        for (long toWait = this.pauseInterval; !this.closed && toWait > 0L; toWait -= now - start) {
                            try {
                                this.wait(toWait);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            now = System.currentTimeMillis();
                            start = now;
                        }
                    }
                }
                catch (Throwable e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }

    private final class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            ConnectionEntry conn = (ConnectionEntry)RemotingServiceImpl.this.connections.get(connectionID);
            if (conn != null) {
                conn.connection.bufferReceived(connectionID, buffer);
            } else if (log.isTraceEnabled()) {
                log.trace("ConnectionID = " + connectionID + " was already closed, so ignoring packet");
            }
        }
    }
}

