/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;

public class UncomposedMessageDeliveryAdapter {
    private ServiceInvoker serviceInvoker;
    private MessageComposer composer;

    public UncomposedMessageDeliveryAdapter(String serviceCategory, String serviceName, MessageComposer composer) throws MessageDeliverException {
        AssertArgument.isNotNull(serviceCategory, "serviceCategory");
        AssertArgument.isNotNull(serviceName, "serviceName");
        AssertArgument.isNotNull(composer, "composer");
        this.serviceInvoker = new ServiceInvoker(serviceCategory, serviceName);
        this.composer = composer;
    }

    public Object deliverSync(Object messagePayload, long timeoutMillis) throws MessageDeliverException, RegistryException, FaultMessageException {
        Message message = this.deliverSyncWithoutDecomposing(messagePayload, timeoutMillis);
        return this.composer.decompose(message, messagePayload);
    }

    public Message deliverSyncWithoutDecomposing(Object messagePayload, long timeoutMillis) throws MessageDeliverException, RegistryException, FaultMessageException {
        AssertArgument.isNotNull(messagePayload, "messagePayload");
        Message message = this.composer.compose(messagePayload);
        return this.serviceInvoker.deliverSync(message, timeoutMillis);
    }

    public void deliverAsync(Object messagePayload) throws MessageDeliverException, RegistryException {
        AssertArgument.isNotNull(messagePayload, "messagePayload");
        Message message = this.composer.compose(messagePayload);
        this.serviceInvoker.deliverAsync(message);
    }

    public ServiceInvoker getDeliveryAdapter() {
        return this.serviceInvoker;
    }

    public static UncomposedMessageDeliveryAdapter getGatewayDeliveryAdapter(ConfigTree gatewayConfig, MessageComposer defaultComposer) throws ConfigurationException {
        String targetServiceCategory = gatewayConfig.getAttribute("target-service-category");
        String targetServiceName = gatewayConfig.getAttribute("target-service-name");
        String composerClass = gatewayConfig.getAttribute("composer-class");
        if (targetServiceCategory == null || targetServiceCategory.trim().equals("")) {
            throw new ConfigurationException("Invalid gateway configuration.  'target-service-category' not specified.");
        }
        if (targetServiceName == null || targetServiceName.trim().equals("")) {
            throw new ConfigurationException("Invalid gateway configuration.  'target-service-name' not specified.");
        }
        try {
            MessageComposer composer = composerClass != null ? MessageComposer.Factory.getInstance(composerClass, gatewayConfig) : defaultComposer;
            composer.setConfiguration(gatewayConfig);
            return new UncomposedMessageDeliveryAdapter(targetServiceCategory, targetServiceName, composer);
        }
        catch (MessageDeliverException e) {
            throw new ConfigurationException("Remoting Listener configuration failed.", e);
        }
    }
}

