/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.ActionProcessorMethodInfo;
import org.jboss.soa.esb.message.Message;

final class OverriddenActionProcessor
implements ActionPipelineProcessor {
    private final ActionProcessorMethodInfo methodInfo;
    private final Constructor constructor;
    private final ConfigTree config;
    private Map<Message, Object> messageInstanceMap = Collections.synchronizedMap(new HashMap());

    OverriddenActionProcessor(ConfigTree config, Class actionClass) throws ConfigurationException {
        this.config = config;
        this.constructor = ActionProcessorMethodInfo.getActionClassConstructor(actionClass);
        this.methodInfo = ActionProcessorMethodInfo.getMethodInfo(config, actionClass);
    }

    public Message process(Message message) throws ActionProcessingException {
        if (this.methodInfo.hasProcessMethods()) {
            Object instance;
            try {
                instance = ActionProcessorMethodInfo.getActionClassInstance(this.config, this.constructor);
            }
            catch (ConfigurationException ce) {
                throw new ActionProcessingException("Unexpected exception creating action class instance", ce);
            }
            this.messageInstanceMap.put(message, instance);
            return this.methodInfo.processMethods(instance, message);
        }
        return message;
    }

    public void processException(Message message, Throwable th) {
        Object instance = this.messageInstanceMap.remove(message);
        if (instance != null) {
            this.methodInfo.processException(instance, message, th);
        }
    }

    public void processSuccess(Message message) {
        Object instance = this.messageInstanceMap.remove(message);
        if (instance != null) {
            this.methodInfo.processSuccess(instance, message);
        }
    }

    public void initialise() throws ActionLifecycleException {
        this.messageInstanceMap.clear();
    }

    public void destroy() throws ActionLifecycleException {
        this.messageInstanceMap.clear();
    }
}

