/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.message.Message;

public class ActionStatusBean {
    private int m_procCount;
    private String m_status;
    private long m_procTime;
    private long m_bytesProcessed;
    private long serviceTime;
    public static final String ACTION_SENT = "SENT";
    public static final String ACTION_FAILED = "FAILED";

    public ActionStatusBean(long procTime, int f_procCount, Message f_message, String f_status, String objectName) {
        this.m_procTime = procTime;
        this.m_procCount = f_procCount;
        this.m_status = f_status;
        this.m_bytesProcessed = 0L;
        this.serviceTime = 0L;
        String timeLabel = objectName + "Time";
        try {
            String bytes = (String)f_message.getProperties().getProperty("org.jboss.soa.esb.message.byte.size");
            if (f_message.getProperties().getProperty(timeLabel) != null) {
                Long messageServiceTime = (Long)f_message.getProperties().getProperty(objectName + "Time");
                this.serviceTime = messageServiceTime + procTime;
                f_message.getProperties().setProperty(timeLabel, new Long(this.serviceTime));
            } else {
                this.serviceTime = procTime;
                f_message.getProperties().setProperty(timeLabel, new Long(procTime));
            }
            this.m_bytesProcessed = Long.parseLong(bytes);
        }
        catch (NullPointerException npe) {
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    public long getBytesProcessed() {
        return this.m_bytesProcessed;
    }

    public int getProcCount() {
        return this.m_procCount;
    }

    public String getStatus() {
        return this.m_status;
    }

    public long getProcTime() {
        return this.m_procTime;
    }

    public long getServiceTime() {
        return this.serviceTime;
    }
}

