/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ManagedLifecycleState {
    CONSTRUCTED{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == INITIALISING;
        }
    }
    ,
    INITIALISING{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == INITIALISED || newState == DESTROYED;
        }
    }
    ,
    INITIALISED{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STARTING || newState == DESTROYING;
        }
    }
    ,
    STARTING{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STARTED || newState == STOPPED;
        }
    }
    ,
    STARTED{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == RUNNING || newState == STOPPING;
        }
    }
    ,
    RUNNING{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STOPPING;
        }
    }
    ,
    STOPPING{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STOPPED;
        }
    }
    ,
    STOPPED{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STARTING || newState == DESTROYING;
        }
    }
    ,
    DESTROYING{

        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == DESTROYED;
        }
    }
    ,
    DESTROYED{

        public boolean canTransition(ManagedLifecycleState newState) {
            return false;
        }
    };


    public abstract boolean canTransition(ManagedLifecycleState var1);
}

