/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.persist.JdbcCleanConn;
import org.jboss.soa.esb.helpers.persist.SimpleDataSource;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.lifecycle.AbstractThreadedManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleThreadState;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTableGatewayListener
extends AbstractThreadedManagedLifecycle {
    private TransactionStrategy transactionStrategy;
    protected static final Logger _logger = Logger.getLogger(SqlTableGatewayListener.class);
    protected ConfigTree _config;
    protected long _sleepBetweenPolls;
    protected String _targetServiceCategory;
    protected String _targetServiceName;
    protected String _composerName;
    protected ServiceInvoker _serviceInvoker;
    protected Class _composerClass;
    protected Object _composer;
    protected Method _processMethod;
    protected String _driver;
    protected String _url;
    protected String _user;
    protected String _password;
    protected String _datasource;
    protected String _tableName;
    protected String _selectFields;
    protected String _keyFields;
    protected String _timestamp;
    protected String _where;
    protected String _orderBy;
    protected String _inProcessField;
    protected String _inProcessVals;
    protected boolean _deleteAfterOK;
    protected String[] _columns;
    protected String[] _keys;
    protected PreparedStatement _PSscan;
    protected PreparedStatement _PSupdate;
    protected PreparedStatement _PSdeleteRow;
    protected JdbcCleanConn _dbConn;
    protected Map<String, Object> _currentRow;
    protected Map<String, Object> _upperCurrentRow;
    public static final String DEFAULT_IN_PROCESS_STATES = "PWED";

    public SqlTableGatewayListener(ConfigTree config) throws ConfigurationException {
        super(config);
        this._config = config;
        this._sleepBetweenPolls = 10000L;
        this.checkMyParms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        try {
            List<EPR> _targetEprs = RegistryUtil.getEprs(this._targetServiceCategory, this._targetServiceName);
            if (null == _targetEprs || _targetEprs.size() < 1) {
                throw new ManagedLifecycleException("EPR <" + this._targetServiceName + "> not found in registry");
            }
        }
        catch (ServiceNotFoundException snfe) {
            throw new ManagedLifecycleException("EPR <" + this._targetServiceName + " " + this._targetServiceName + "> not found in registry");
        }
        catch (RegistryException re) {
            throw new ManagedLifecycleException("Unexpected registry exception", re);
        }
        try {
            this._serviceInvoker = new ServiceInvoker(this._targetServiceCategory, this._targetServiceName);
            this._serviceInvoker.loadServiceClusterInfo();
        }
        catch (MessageDeliverException mde) {
            throw new ManagedLifecycleException(mde);
        }
        boolean failure = true;
        try {
            this._dbConn = this.getDbConn();
            failure = false;
        }
        finally {
            if (failure && this._dbConn != null) {
                this._dbConn.release();
                this._dbConn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("doRun() method of " + this.getClass().getSimpleName() + " started on thread " + Thread.currentThread().getName()));
        }
        try {
            do {
                this.transactionStrategy.begin();
                boolean rollbackOnly = true;
                try {
                    for (Map<String, Object> row : this.pollForCandidates()) {
                        this._currentRow = row;
                        if (!this.changeStatusToWorking()) continue;
                        Exception thrown = null;
                        String text = null;
                        try {
                            Object obj = this._processMethod.invoke(this._composer, this._currentRow);
                            if (null == obj) {
                                _logger.warn((Object)("Action class method <" + this._processMethod.getName() + "> returned a null object"));
                                continue;
                            }
                            Message message = (Message)obj;
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("org.jboss.soa.esb.gateway.config", this._config);
                            message = FilterManager.getInstance().doOutputWork(message, params);
                            this._serviceInvoker.deliverAsync(message);
                        }
                        catch (MessageDeliverException e) {
                            thrown = e;
                            text = "Target service <" + this._targetServiceCategory + "," + this._targetServiceName + "> is not registered";
                        }
                        catch (InvocationTargetException e) {
                            thrown = e;
                            text = "Problems invoking method <" + this._processMethod.getName() + ">";
                        }
                        catch (IllegalAccessException e) {
                            thrown = e;
                            text = "Problems invoking method <" + this._processMethod.getName() + ">";
                        }
                        catch (ClassCastException e) {
                            thrown = e;
                            text = "Action class method <" + this._processMethod.getName() + "> returned a non Message object";
                        }
                        catch (CourierException e) {
                            thrown = e;
                            text = "Message filter FAILED";
                        }
                        if (null == thrown) {
                            if (this._deleteAfterOK) {
                                this.deleteCurrentRow();
                                continue;
                            }
                            this.changeStatusToDone();
                            continue;
                        }
                        _logger.error((Object)text);
                        _logger.debug((Object)text, (Throwable)thrown);
                        this.changeStatusToError();
                    }
                    rollbackOnly = false;
                }
                finally {
                    if (rollbackOnly) {
                        this.transactionStrategy.rollbackOnly();
                    }
                    this.transactionStrategy.terminate();
                }
            } while (!this.waitForRunningStateChange(ManagedLifecycleThreadState.STOPPING, this._sleepBetweenPolls));
        }
        catch (TransactionStrategyException tse) {
            _logger.warn((Object)"Unexpected transaction strategy exception", (Throwable)tse);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("run() method of " + this.getClass().getSimpleName() + " finished on thread " + Thread.currentThread().getName()));
        }
    }

    @Override
    protected void doThreadedDestroy() throws ManagedLifecycleException {
        if (this._dbConn != null) {
            this._dbConn.release();
        }
    }

    private void checkMyParms() throws ConfigurationException {
        this._targetServiceCategory = ListenerUtil.getValue(this._config, "target-service-category", null);
        this._targetServiceName = ListenerUtil.getValue(this._config, "target-service-name", null);
        if (this._targetServiceCategory == null) {
            throw new ConfigurationException("No service category defined!");
        }
        if (this._targetServiceName == null) {
            throw new ConfigurationException("No service name defined!");
        }
        String sAux = this._config.getAttribute("pollLatencySeconds");
        if (!Util.isNullString(sAux)) {
            try {
                this._sleepBetweenPolls = 1000L * Long.parseLong(sAux);
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)("Invalid poll latency - keeping default of " + this._sleepBetweenPolls / 1000L));
            }
        } else {
            _logger.warn((Object)("No value specified for: pollLatencySeconds -  Using default of " + this._sleepBetweenPolls / 1000L));
        }
        this.resolveComposerClass();
        this._driver = ListenerUtil.getValue(this._config, "driver", null);
        this._url = ListenerUtil.getValue(this._config, "URL", null);
        this._user = ListenerUtil.getValue(this._config, "username", null);
        this._password = ListenerUtil.getValue(this._config, "password", "");
        this._datasource = ListenerUtil.getValue(this._config, "datasource", null);
        this._tableName = this._config.getAttribute("tableName");
        if (null == this._tableName) {
            this._tableName = this._config.getRequiredAttribute("tablename");
        }
        if (Util.isNullString(this._tableName)) {
            throw new ConfigurationException("Empty or invalid table name");
        }
        this._selectFields = ListenerUtil.getValue(this._config, "selectFields", "*");
        if (Util.isNullString(this._selectFields)) {
            throw new ConfigurationException("Empty or invalid list of select fields");
        }
        this._keyFields = this._config.getAttribute("keyFields");
        if (null == this._keyFields) {
            this._keyFields = this._config.getRequiredAttribute("message_id_column");
        }
        if (Util.isNullString(this._keyFields)) {
            throw new ConfigurationException("Empty or invalid list of key fields");
        }
        this._inProcessField = this._config.getAttribute("inProcessField");
        if (null == this._inProcessField) {
            this._inProcessField = this._config.getAttribute("status_column");
        }
        if (Util.isNullString(this._inProcessField)) {
            throw new ConfigurationException("A valid inProcessField attribute must be specified");
        }
        this._timestamp = ListenerUtil.getValue(this._config, "insert_timestamp_column");
        if (this._timestamp == null || this._timestamp.trim().length() == 0) {
            _logger.debug((Object)"No value specified for: insert-timestamp-column");
            this._timestamp = null;
        }
        this._where = ListenerUtil.getValue(this._config, "whereCondition", "");
        if (this._where.trim().length() < 1) {
            _logger.debug((Object)"No value specified for: whereCondition");
        }
        this._orderBy = ListenerUtil.getValue(this._config, "orderBy", "");
        if (this._orderBy.trim().length() < 1) {
            _logger.debug((Object)"No value specified for: orderBy");
        }
        this._inProcessVals = ListenerUtil.getValue(this._config, "inProcessValues", DEFAULT_IN_PROCESS_STATES);
        this._deleteAfterOK = Boolean.parseBoolean(ListenerUtil.getValue(this._config, "postDelete", "false"));
        if (null == this._config.getAttribute("postDelete")) {
            _logger.debug((Object)"No value specified for: postDelete - trigger row will not be deleted - 'in process field' will be used to show processing status");
        }
        if (this._inProcessVals.length() < 4) {
            throw new ConfigurationException("Parameter <inProcessValues> must be at least 4 characters long (PWED)");
        }
        this._columns = this._selectFields.split(",");
        if (this._columns.length < 1) {
            throw new ConfigurationException("Empty list of select fields");
        }
        this._keys = this._keyFields.split(",");
        if (!"*".equals(this._selectFields)) {
            HashSet<String> colSet = new HashSet<String>(Arrays.asList(this._columns));
            if (this._keys.length < 1) {
                throw new ConfigurationException("Empty list of keyFields");
            }
            for (String currKey : this._keys) {
                if (colSet.contains(currKey)) continue;
                StringBuilder sb = new StringBuilder().append("All key field names in the <").append("keyFields").append("> attribute must be in the ").append("selectFields").append("list - '").append(currKey).append("' is not there");
                throw new ConfigurationException(sb.toString());
            }
        }
        boolean transacted = this._config.getBooleanAttribute("transacted", false);
        this.transactionStrategy = TransactionStrategy.getTransactionStrategy(transacted);
    }

    protected void prepareStatements() throws SQLException {
        this._PSscan = this._dbConn.prepareStatement(this.scanStatement());
        this._PSupdate = this._dbConn.prepareStatement(this.updateStatement());
        this._PSdeleteRow = this._dbConn.prepareStatement(this.deleteStatement());
    }

    protected void resolveComposerClass() throws ConfigurationException {
        try {
            String sProcessMethod = null;
            this._composerName = this._config.getAttribute("composer-class");
            if (null != this._composerName) {
                this._composerClass = ClassUtil.forName(this._composerName, this.getClass());
                Constructor oConst = this._composerClass.getConstructor(ConfigTree.class);
                this._composer = oConst.newInstance(this._config);
                sProcessMethod = this._config.getAttribute("composer-process", "process");
            } else {
                this._composerName = PackageRowContents.class.getName();
                this._composerClass = PackageRowContents.class;
                this._composer = new PackageRowContents(PackageRowContents.createPayloadProxy(this._config));
                sProcessMethod = "process";
                _logger.debug((Object)("No <action> element found in configuration -  Using default composer class : " + this._composerName));
            }
            this._processMethod = this._composerClass.getMethod(sProcessMethod, Object.class);
        }
        catch (InvocationTargetException ex) {
            _logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            _logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (InstantiationException ex) {
            _logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (ClassNotFoundException ex) {
            _logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (NoSuchMethodException ex) {
            _logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> pollForCandidates() {
        ArrayList<Map<String, Object>> oResults = new ArrayList<Map<String, Object>>();
        JdbcCleanConn oConn = this.getDbConn();
        ResultSet RS = null;
        try {
            RS = oConn.execQueryWait(this._PSscan, 1);
            ResultSetMetaData meta = RS.getMetaData();
            while (RS.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int iCurr = 1; iCurr <= meta.getColumnCount(); ++iCurr) {
                    String sCol = meta.getColumnName(iCurr);
                    if (this._inProcessField.equalsIgnoreCase(sCol)) continue;
                    int type = meta.getColumnType(iCurr);
                    if (type == 2004) {
                        Blob blob = RS.getBlob(iCurr);
                        row.put(sCol, blob != null ? StreamUtils.readStreamString(blob.getBinaryStream(), "UTF-8") : null);
                        continue;
                    }
                    if (type == 2005) {
                        Clob clob = RS.getClob(iCurr);
                        row.put(sCol, clob != null ? StreamUtils.readReader(clob.getCharacterStream()) : null);
                        continue;
                    }
                    row.put(sCol, RS.getObject(iCurr));
                }
                oResults.add(row);
            }
        }
        catch (Exception e) {
            _logger.debug((Object)"Some triggers might not have been returned", (Throwable)e);
        }
        finally {
            try {
                if (RS != null) {
                    RS.close();
                }
                oConn.rollback();
            }
            catch (SQLException sqle) {
                this.refreshDatasource();
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Returning " + oResults.size() + " rows.\n"));
        }
        return oResults;
    }

    public void refreshDatasource() {
        this._dbConn = null;
        if (this._datasource != null) {
            this.getDbConn();
        }
    }

    protected JdbcCleanConn getDbConn() {
        DataSource oDS = null;
        if (null == this._dbConn) {
            if (this._datasource == null) {
                oDS = new SimpleDataSource(this._driver, this._url, this._user, this._password);
            } else {
                try {
                    InitialContext initContext = new InitialContext();
                    oDS = (DataSource)initContext.lookup(this._datasource);
                }
                catch (NamingException e) {
                    _logger.error((Object)"SqlTableGatewayListener.getDbConn failed to lookup datasource.", (Throwable)e);
                }
            }
            this._dbConn = new JdbcCleanConn(oDS);
        }
        if (null != this._dbConn && this._dbConn.getStatements().size() == 0) {
            try {
                this.prepareStatements();
            }
            catch (SQLException e) {
                _logger.warn((Object)"Exception preparing statements", (Throwable)e);
            }
        }
        return this._dbConn;
    }

    protected String scanStatement() {
        boolean bWhere;
        StringBuilder sb = new StringBuilder().append("select ").append(this._selectFields).append(" from ").append(this._tableName);
        boolean bl = bWhere = !Util.isNullString(this._where);
        if (bWhere) {
            sb.append(" where ").append(this._where);
        }
        sb.append(bWhere ? " and " : " where ");
        String sLike = this._inProcessVals.substring(0, 1).toUpperCase();
        sb.append(" upper(").append(this._inProcessField).append(") like '").append(sLike).append("%'");
        if (!Util.isNullString(this._orderBy)) {
            sb.append(" order by ").append(this._orderBy);
        }
        return sb.toString();
    }

    protected String updateStatement() {
        StringBuilder sb = new StringBuilder().append("update ").append(this._tableName).append(" set ").append(this._inProcessField).append(" = ? ");
        if (this._timestamp != null) {
            sb.append(", " + this._timestamp + " = ? ");
        }
        sb.append("where ").append(this._inProcessField).append(" = ?");
        for (String sCurr : this._keys) {
            sb.append(" and ").append(sCurr).append(" = ?");
        }
        return sb.toString();
    }

    protected String deleteStatement() {
        StringBuilder sb = new StringBuilder().append("delete from ").append(this._tableName).append(" where ");
        int iCurr = 0;
        for (String sCurr : this._keys) {
            if (iCurr++ > 0) {
                sb.append(" and ");
            }
            sb.append(sCurr).append(" = ?");
        }
        return sb.toString();
    }

    protected boolean deleteCurrentRow() {
        try {
            int iParm = 1;
            for (String sColName : this._keys) {
                Object val = this._currentRow.containsKey(sColName) ? this._currentRow.get(sColName) : this._upperCurrentRow.get(sColName.toUpperCase());
                this._PSdeleteRow.setObject(iParm++, val);
            }
            try {
                this.getDbConn().execUpdWait(this._PSdeleteRow, 5);
                this.getDbConn().commit();
                return true;
            }
            catch (Exception e) {
                _logger.debug((Object)"Delete row has failed.  Rolling back!!", (Throwable)e);
                try {
                    this.getDbConn().rollback();
                }
                catch (Exception e2) {
                    _logger.debug((Object)"Unable to rollback delete row", (Throwable)e2);
                }
            }
        }
        catch (Exception e) {
            _logger.debug((Object)"Unexpected exception.", (Throwable)e);
        }
        return false;
    }

    protected String getStatus(ROW_STATE p_oState) {
        int iPos = p_oState.ordinal();
        return this._inProcessVals.substring(iPos++, iPos);
    }

    protected boolean changeStatusToWorking() {
        return this.changeStatus(ROW_STATE.Pending, ROW_STATE.Working);
    }

    protected boolean changeStatusToDone() {
        return this.changeStatus(ROW_STATE.Working, ROW_STATE.Done);
    }

    protected boolean changeStatusToError() {
        return this.changeStatus(ROW_STATE.Working, ROW_STATE.Error);
    }

    protected boolean changeStatus(ROW_STATE fromState, ROW_STATE toState) {
        try {
            this.getDbConn();
        }
        catch (Exception e) {
            _logger.debug((Object)"Unable to get DB connection.", (Throwable)e);
            throw new IllegalStateException("Unable to get DB connection.", e);
        }
        int iParm = 3;
        if (this._timestamp != null) {
            ++iParm;
        }
        ArrayList<String> tempKeys = new ArrayList<String>();
        for (String key : this._currentRow.keySet()) {
            tempKeys.add(key);
        }
        if (this._upperCurrentRow != null) {
            this._upperCurrentRow.clear();
        } else {
            this._upperCurrentRow = new HashMap<String, Object>();
        }
        for (String key : tempKeys) {
            Object value = this._currentRow.get(key);
            this._upperCurrentRow.put(key.toUpperCase(), value);
        }
        for (String sColName : this._keys) {
            Object oVal = null;
            oVal = this._currentRow.containsKey(sColName) ? this._currentRow.get(sColName) : this._upperCurrentRow.get(sColName.toUpperCase());
            this._PSupdate.setObject(iParm++, oVal);
        }
        try {
            int counter = 1;
            this._PSupdate.setString(counter++, this.getStatus(toState));
            if (this._timestamp != null) {
                Date now = new Date();
                this._PSupdate.setString(counter++, now.toString());
            }
            this._PSupdate.setString(counter++, this.getStatus(fromState));
            int count = this.getDbConn().execUpdWait(this._PSupdate, 5);
            if (count == 1) {
                this.getDbConn().commit();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Successfully changed row state from " + (Object)((Object)fromState) + " to " + (Object)((Object)toState) + "."));
                }
                return true;
            }
            _logger.warn((Object)("Cannot change row state from " + (Object)((Object)fromState) + " to " + (Object)((Object)toState) + ".  Number of rows in state " + (Object)((Object)fromState) + " = " + count));
            if (count == 0) {
                _logger.warn((Object)"No rows affected by update statement. Check listener/gateway/notifier table definitions are correct.");
            } else {
                _logger.warn((Object)"Curent implementation expected only one row to be applicable to update request.");
            }
            return false;
        }
        catch (Exception e) {
            try {
                String message = "Row status change to " + (Object)((Object)toState) + " has failed.  Rolling back!!";
                _logger.error((Object)message);
                _logger.debug((Object)message, (Throwable)e);
                try {
                    this.getDbConn().rollback();
                }
                catch (Exception e2) {
                    message = "Unable to rollback row status change to " + (Object)((Object)fromState);
                    _logger.error((Object)message);
                    _logger.debug((Object)message, (Throwable)e2);
                }
            }
            catch (Exception e3) {
                String message = "Unexpected exception.";
                _logger.error((Object)"Unexpected exception.");
                _logger.debug((Object)"Unexpected exception.", (Throwable)e3);
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ROW_STATE {
        Pending,
        Working,
        Error,
        Done;

    }

    public static class PackageRowContents {
        private MessagePayloadProxy payloadProxy;

        public PackageRowContents(MessagePayloadProxy payloadProxy) {
            this.payloadProxy = payloadProxy;
        }

        public Message process(Object obj) throws MessageDeliverException {
            if (!(obj instanceof Serializable)) {
                throw new IllegalArgumentException("Object must be instance of Map");
            }
            Message message = MessageFactory.getInstance().getMessage();
            Properties props = message.getProperties();
            if (MessagePayloadProxy.isUsingLegacyPatterns()) {
                props.setProperty("sqlRowData", obj);
            } else {
                this.payloadProxy.setPayload(message, obj);
            }
            return message;
        }

        public static MessagePayloadProxy createPayloadProxy(ConfigTree config) {
            return new MessagePayloadProxy(config);
        }
    }
}

