/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.remoting.HttpMarshaller;
import org.jboss.internal.soa.esb.remoting.HttpUnmarshaller;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.Connector;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.AbstractMessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.listeners.message.UncomposedMessageDeliveryAdapter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.message.ResponseHeader;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryFactory;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.ExtractorUtil;
import org.jboss.soa.esb.services.security.auth.http.JbrHttpSecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.WSSecurityInfoExtractor;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRemotingGatewayListener
extends AbstractManagedLifecycle
implements ServerInvocationHandler {
    public static final String JBR_PREFIX = "jbr-";
    public static final String JBR_SERVER_PROTOCOL = "jbr-serverProtocol";
    public static final String JBR_SERVER_HOST = "jbr-serverBindAddress";
    public static final String JBR_SERVER_PORT = "jbr-serverBindPort";
    private static ThreadLocal<InvocationRequest> currentRequest = new ThreadLocal();
    private static Logger logger = Logger.getLogger(JBossRemotingGatewayListener.class);
    private Connector connector;
    private final Map<String, String> connectorConfig = new HashMap<String, String>();
    private String jbrServerLocatorURI;
    private UncomposedMessageDeliveryAdapter messageDeliveryAdapter;
    private boolean initialised;
    private final String serviceCategory;
    private final String serviceName;
    private EPR endpointReference;
    private boolean synchronous = true;
    private final String asyncResponse;
    private boolean isHttp;
    private long serviceInvokerTimeout;
    private static Map<String, String> legacySSLConfigNameMappings;

    public JBossRemotingGatewayListener(ConfigTree config) throws ConfigurationException {
        super(config);
        this.serviceCategory = config.getAttribute("target-service-category");
        this.serviceName = config.getAttribute("target-service-name");
        boolean bl = this.synchronous = !config.getAttribute("synchronous", "true").equalsIgnoreCase("false");
        if (this.synchronous) {
            this.serviceInvokerTimeout = config.getLongAttribute("serviceInvokerTimeout", 20000L);
        }
        this.asyncResponse = config.getAttribute("asyncResponse");
        if (this.asyncResponse != null && ClassUtil.getResourceAsStream(this.asyncResponse, this.getClass()) == null) {
            throw new ConfigurationException("Asynchronous response resource file '" + this.asyncResponse + "' not found on classpath.");
        }
    }

    public static InvocationRequest getCurrentRequest() {
        return currentRequest.get();
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public boolean isStarted() {
        return this.connector != null;
    }

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        if (this.isInitialised()) {
            throw new ManagedLifecycleException("Unexpected request to initialise JBoss Remoting Gateway listener '" + this.getConfig().getName() + "'.  Gateway already initialised.");
        }
        try {
            this.endpointReference = new EPR(this.getJbrServerLocatorURI());
            this.messageDeliveryAdapter = this.createDeliveryAdapter();
            this.initaliseJBRConnectorConfiguration(this.connectorConfig);
            String protocol = this.getConfig().getAttribute(JBR_SERVER_PROTOCOL);
            this.isHttp = protocol.equals("http") || protocol.equals("https");
        }
        catch (ConfigurationException e) {
            throw new ManagedLifecycleException("Remoting Listener configuration failed.", e);
        }
        this.initialised = true;
    }

    @Override
    protected void doStart() throws ManagedLifecycleException {
        if (!this.isInitialised()) {
            throw new ManagedLifecycleException("Unexpected request to start JBoss Remoting Gateway listener '" + this.getConfig().getName() + "'.  Gateway not initialised.");
        }
        if (this.isStarted()) {
            throw new ManagedLifecycleException("Unexpected request to start JBoss Remoting Gateway listener '" + this.getConfig().getName() + "'.  Gateway already started.");
        }
        this.startJBRServer();
        try {
            this.registerEndpoint();
        }
        catch (Throwable t) {
            logger.error((Object)("Unable to register service endpoint '" + this.endpointReference.getAddr().getAddress() + "' for service '" + this.serviceCategory + ":" + this.serviceName + "'.  Stopping JBossRemoting Server..."), t);
            this.stopJBRServer();
        }
    }

    @Override
    protected void doStop() throws ManagedLifecycleException {
        if (!this.isStarted()) {
            throw new ManagedLifecycleException("Unexpected request to stop JBoss Remoting Gateway listener '" + this.getConfig().getName() + "'.  Gateway not running.");
        }
        this.unregisterEndpoint();
        this.stopJBRServer();
    }

    private void startJBRServer() throws ManagedLifecycleException {
        try {
            InvokerLocator locator = new InvokerLocator(this.jbrServerLocatorURI);
            this.connector = new Connector(locator, this.connectorConfig);
            this.connector.create();
            this.connector.addInvocationHandler(this.getConfig().getAttribute("name", this.toString()), (ServerInvocationHandler)this);
            this.connector.start();
            logger.info((Object)("JBoss Remoting Gateway listener '" + this.getConfig().getName() + "' started."));
        }
        catch (Throwable throwable) {
            if (this.connector != null) {
                this.connector.stop();
            }
            this.connector = null;
            throw new ManagedLifecycleException("Unable to start Remoting Listener instsance " + this.getClass().getName(), throwable);
        }
    }

    private void stopJBRServer() throws ManagedLifecycleException {
        try {
            this.connector.stop();
            logger.info((Object)("JBoss Remoting Gateway listener '" + this.getConfig().getName() + "' stopped."));
        }
        catch (Throwable throwable) {
            throw new ManagedLifecycleException("Unable to stop Remoting Listener instsance " + this.getClass().getName(), throwable);
        }
        finally {
            this.connector = null;
        }
    }

    private void registerEndpoint() throws ConfigurationException, RegistryException {
        String serviceDescription = this.getConfig().getAttribute("service-description");
        RegistryFactory.getRegistry().registerEPR(this.serviceCategory, this.serviceName, serviceDescription, this.endpointReference, this.endpointReference.getAddr().getAddress());
    }

    private void unregisterEndpoint() {
        try {
            RegistryFactory.getRegistry().unRegisterEPR(this.serviceCategory, this.serviceName, this.endpointReference);
        }
        catch (Throwable t) {
            logger.error((Object)("Unable to unregister service endpoint '" + this.endpointReference.getAddr().getAddress() + "' for service '" + this.serviceCategory + ":" + this.serviceName + "'."), t);
        }
    }

    @Override
    protected void doDestroy() throws ManagedLifecycleException {
    }

    public Object invoke(InvocationRequest invocationRequest) throws Throwable {
        Map responseMap = JBossRemotingGatewayListener.getJBRResponseMap(invocationRequest);
        currentRequest.set(invocationRequest);
        try {
            if (this.synchronous) {
                Object response = this.messageDeliveryAdapter.deliverSync(invocationRequest, this.serviceInvokerTimeout);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Returning response [" + response + "]."));
                }
                if (this.isHttp) {
                    Object code = responseMap.get("ResponseCode");
                    Integer responseCode = code != null ? Integer.valueOf(code.toString()) : Integer.valueOf(200);
                    responseMap.put("ResponseCode", responseCode);
                    String responseCodeMessage = (String)responseMap.get("ResponseCodeMessage");
                    if (responseCodeMessage == null) {
                        responseCodeMessage = "OK";
                    }
                    responseMap.put("ResponseCodeMessage", responseCodeMessage);
                }
                return response;
            }
            this.messageDeliveryAdapter.deliverAsync(invocationRequest);
            if (this.isHttp) {
                responseMap.put("ResponseCode", 202);
                responseMap.put("ResponseCodeMessage", "OK");
            }
            if (this.asyncResponse == null) {
                return "<ack/>";
            }
            return StreamUtils.readStreamString(this.getClass().getResourceAsStream(this.asyncResponse), "UTF-8");
        }
        catch (Throwable t) {
            logger.debug((Object)("JBoss Remoting Gateway failed to " + (this.synchronous ? "synchronously" : "asynchronously") + " deliver message to target service [" + this.messageDeliveryAdapter.getDeliveryAdapter().getServiceCategory() + ":" + this.messageDeliveryAdapter.getDeliveryAdapter().getServiceName() + "]."), t);
            if (this.isHttp) {
                StringWriter stringWriter = new StringWriter();
                this.mapHTTPErrorDetails(responseMap, t);
                t.printStackTrace(new PrintWriter(stringWriter));
                responseMap.put("Content-Type", "text/plain");
                return stringWriter.toString();
            }
            throw t;
        }
    }

    private void mapHTTPErrorDetails(Map responseMap, Throwable t) {
        Throwable cause = t.getCause();
        if (cause instanceof SecurityServiceException && cause.getCause() instanceof LoginException) {
            responseMap.put("ResponseCode", 401);
            responseMap.put("ResponseCodeMessage", "Invalid Login Credentials.");
        } else {
            responseMap.put("ResponseCode", 500);
            responseMap.put("ResponseCodeMessage", "Failed to service request.");
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    public void setInvoker(ServerInvoker serverInvoker) {
    }

    public void addListener(InvokerCallbackHandler invokerCallbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler invokerCallbackHandler) {
    }

    protected void initaliseJBRConnectorConfiguration(Map<String, String> connectorConfig) throws ConfigurationException {
        String protocol = this.getJbrServerLocatorURI().getScheme();
        boolean isHttps = protocol.equals("https");
        boolean isSecure = isHttps || protocol.equals("sslsocket");
        this.jbrServerLocatorURI = this.getJbrServerLocatorURI().toString();
        if (isHttps) {
            connectorConfig.put("SSLImplementation", "org.jboss.remoting.transport.coyote.ssl.RemotingSSLImplementation");
        }
        List<KeyValuePair> attributes = this.getConfig().attributesAsList();
        for (KeyValuePair attribute : attributes) {
            String attributeName = attribute.getKey();
            if (!attributeName.startsWith(JBR_PREFIX)) continue;
            String jbrAttributeName = attributeName.substring(JBR_PREFIX.length());
            String postv220JbrSSLAttributeName = legacySSLConfigNameMappings.get(jbrAttributeName);
            connectorConfig.put(jbrAttributeName, attribute.getValue());
            if (postv220JbrSSLAttributeName != null) {
                connectorConfig.put(postv220JbrSSLAttributeName, attribute.getValue());
                connectorConfig.put("UseSSLServerSocketFactory", "false");
                continue;
            }
            if (!legacySSLConfigNameMappings.containsValue(jbrAttributeName)) continue;
            connectorConfig.put("UseSSLServerSocketFactory", "false");
        }
        if (isSecure && !connectorConfig.containsKey("serverSocketFactory")) {
            logger.info((Object)("Secure endpoint '" + this.jbrServerLocatorURI + "' doesn't define a 'serverSocketFactory'.  Using Server defaults.  See JBossRemoting documentation."));
        }
    }

    protected URI getJbrServerLocatorURI() throws ConfigurationException {
        String protocol = this.getConfig().getAttribute(JBR_SERVER_PROTOCOL);
        String host = this.getConfig().getAttribute(JBR_SERVER_HOST);
        String port = this.getConfig().getAttribute(JBR_SERVER_PORT);
        if (protocol == null || protocol.trim().equals("")) {
            throw new ConfigurationException("Invalid JBoss Remoting Gateway configuration [" + this.getConfig().getName() + "]. 'protocol' configuration attribute not specified.");
        }
        if (host == null || host.trim().equals("")) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Invalid JBoss Remoting Gateway configuration [" + this.getConfig().getName() + "]. 'host' configuration attribute not specified and unablee to determine local hostname.", e);
            }
        }
        if (port == null || port.trim().equals("")) {
            throw new ConfigurationException("Invalid JBoss Remoting Gateway configuration [" + this.getConfig().getName() + "]. 'port' configuration attribute not specified.");
        }
        String uriString = protocol + "://" + host + ":" + port;
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid JBoss Remoting Gateway configuration [" + this.getConfig().getName() + "]. Invalid server locator URI '" + uriString + "'.");
        }
    }

    protected UncomposedMessageDeliveryAdapter createDeliveryAdapter() throws ConfigurationException {
        return UncomposedMessageDeliveryAdapter.getGatewayDeliveryAdapter(this.getConfig(), new JBossRemotingMessageComposer());
    }

    private static Map getJBRResponseMap(InvocationRequest invocationRequest) {
        LinkedHashMap responseMap = invocationRequest.getReturnPayload();
        if (responseMap == null) {
            responseMap = new LinkedHashMap();
            invocationRequest.setReturnPayload(responseMap);
        }
        return responseMap;
    }

    static {
        MarshalFactory.addMarshaller((String)"http", (Marshaller)new HttpMarshaller(), (UnMarshaller)new HttpUnmarshaller());
        legacySSLConfigNameMappings = new HashMap<String, String>();
        legacySSLConfigNameMappings.put("ClientAuthMode", "org.jboss.remoting.clientAuthMode");
        legacySSLConfigNameMappings.put("KeyAlias", "org.jboss.remoting.keyAlias");
        legacySSLConfigNameMappings.put("KeyPassword", "org.jboss.remoting.keyPassword");
        legacySSLConfigNameMappings.put("KeyStoreAlgorithm", "org.jboss.remoting.keyStoreAlgorithm");
        legacySSLConfigNameMappings.put("KeyStorePassword", "org.jboss.remoting.keyStorePassword");
        legacySSLConfigNameMappings.put("KeyStoreType", "org.jboss.remoting.keyStoreType");
        legacySSLConfigNameMappings.put("KeyStoreURL", "org.jboss.remoting.keyStore");
        legacySSLConfigNameMappings.put("ProviderName", "org.jboss.remoting.sslProviderName");
        legacySSLConfigNameMappings.put("SecureSocketProtocol", "org.jboss.remoting.sslProtocol");
        legacySSLConfigNameMappings.put("ServerAuthMode", "org.jboss.remoting.serverAuthMode");
        legacySSLConfigNameMappings.put("ServerSocketUse-ClientMode", "org.jboss.remoting.serversocket.useClientMode");
        legacySSLConfigNameMappings.put("SocketUseClient-Mode", "org.jboss.remoting.socket.useClientMode");
        legacySSLConfigNameMappings.put("TrustStoreAlgorithm", "org.jboss.remoting.trustStoreAlgorithm");
        legacySSLConfigNameMappings.put("TrustStorePassword", "org.jboss.remoting.trustStorePassword");
        legacySSLConfigNameMappings.put("TrustStoreType", "org.jboss.remoting.trustStoreType");
        legacySSLConfigNameMappings.put("TrustStoreURL", "org.jboss.remoting.trustStore");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBossRemotingMessageComposer<T extends InvocationRequest>
    extends AbstractMessageComposer<T> {
        private MessagePayloadProxy payloadProxy;
        private JbrHttpSecurityInfoExtractor jbrHttpSecurityExtractor = new JbrHttpSecurityInfoExtractor();
        private WSSecurityInfoExtractor wsSecurityExtractor = new WSSecurityInfoExtractor();

        @Override
        public void setConfiguration(ConfigTree config) {
            super.setConfiguration(config);
            this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.actions.post", "org.jboss.soa.esb.message.defaultEntry", "org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.actions.post"});
            this.payloadProxy.setNullSetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
        }

        @Override
        protected MessagePayloadProxy getPayloadProxy() {
            return this.payloadProxy;
        }

        @Override
        protected void populateMessage(Message message, T invocationRequest) throws MessageDeliverException {
            this.payloadProxy.setPayload(message, invocationRequest.getParameter());
            Map properties = invocationRequest.getRequestPayload();
            if (properties != null) {
                AuthenticationRequest authRequest = this.jbrHttpSecurityExtractor.extractSecurityInfo(properties);
                Object payload = invocationRequest.getParameter();
                if (authRequest == null && payload instanceof String) {
                    authRequest = this.wsSecurityExtractor.extractSecurityInfo((String)payload);
                }
                try {
                    ExtractorUtil.addAuthRequestToMessage(authRequest, message);
                }
                catch (SecurityServiceException e) {
                    throw new MessageDeliverException(e.getMessage(), e);
                }
                Set names = properties.keySet();
                for (Object name : names) {
                    Object value = properties.get(name);
                    if (value == null) continue;
                    message.getProperties().setProperty(name.toString(), value);
                }
            }
        }

        @Override
        public Object decompose(Message message, T invocationRequest) throws MessageDeliverException {
            Properties properties = message.getProperties();
            String[] propertyNames = properties.getNames();
            Map responseMap = JBossRemotingGatewayListener.getJBRResponseMap(invocationRequest);
            for (String name : propertyNames) {
                Object value = properties.getProperty(name);
                if (value instanceof ResponseHeader) {
                    ResponseHeader header = (ResponseHeader)value;
                    header.putNameValue(responseMap);
                }
                if (!"ResponseCode".equals(name) && !"ResponseCodeMessage".equals(name)) continue;
                responseMap.put(name, value);
            }
            return super.decompose(message, invocationRequest);
        }
    }
}

