/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.http.HttpRequestWrapper;
import org.jboss.soa.esb.listeners.message.AbstractMessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessageComposer<T extends HttpRequestWrapper>
extends AbstractMessageComposer<T> {
    private static final Logger logger = Logger.getLogger(HttpMessageComposer.class);
    public static final String HTTP_REQUEST_PARAMETER_MAP = "RequestParameterMap";
    public static final String HTTP_REQUEST_INFO_MAP = "RequestInfoMap";
    public static final String HTTP_RESPONSE_HEADER_MAP = "ResponseHeaderMap";
    public static final String HTTP_RESPONSE_STATUS = "ReponseStatus";
    private MessagePayloadProxy payloadProxy;

    @Override
    public void setConfiguration(ConfigTree config) {
        super.setConfiguration(config);
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.actions.post", "org.jboss.soa.esb.message.defaultEntry", "org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.actions.post"});
        this.payloadProxy.setNullSetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }

    @Override
    protected MessagePayloadProxy getPayloadProxy() {
        return this.payloadProxy;
    }

    @Override
    protected void populateMessage(Message message, T requestWrapper) throws MessageDeliverException {
        HttpServletRequest request = ((HttpRequestWrapper)requestWrapper).getRequest();
        Map paraMap = request.getParameterMap();
        byte[] bodyBytes = null;
        try {
            bodyBytes = StreamUtils.readStream((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new MessageDeliverException("Failed to read body data from http request", e);
        }
        message.getProperties().setProperty(HTTP_REQUEST_INFO_MAP, this.getRequestInfo(request));
        if (paraMap != null && !paraMap.isEmpty()) {
            message.getProperties().setProperty(HTTP_REQUEST_PARAMETER_MAP, paraMap);
        }
        this.payloadProxy.setPayload(message, bodyBytes);
    }

    @Override
    public Object decompose(Message message, T requestWrapper) throws MessageDeliverException {
        Integer status;
        Map headers;
        HttpServletRequest request = ((HttpRequestWrapper)requestWrapper).getRequest();
        HttpServletResponse response = ((HttpRequestWrapper)requestWrapper).getResponse();
        try {
            headers = (Map)message.getProperties().getProperty(HTTP_RESPONSE_HEADER_MAP);
        }
        catch (ClassCastException e) {
            response.setStatus(502);
            logger.debug((Object)("'ResponseHeaderMap' must be of type " + Map.class.getName()));
            return null;
        }
        try {
            status = (Integer)message.getProperties().getProperty(HTTP_RESPONSE_STATUS);
        }
        catch (ClassCastException e) {
            response.setStatus(502);
            logger.debug((Object)"'ReponseStatus' must be of type Integer.");
            return null;
        }
        if (headers != null) {
            Set entries = headers.entrySet();
            for (Map.Entry entry : entries) {
                String headerName = (String)entry.getKey();
                if (headerName.equals("Content-Type")) {
                    response.setContentType((String)entry.getValue());
                    continue;
                }
                response.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Object obj = this.payloadProxy.getPayload(message);
        try {
            byte[] outBytes;
            if (obj instanceof String) {
                String encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                outBytes = ((String)obj).getBytes(encoding);
            } else if (obj instanceof byte[]) {
                outBytes = (byte[])obj;
            } else {
                if (obj == null) {
                    response.setContentLength(0);
                    response.setStatus(204);
                    logger.debug((Object)("Expected a response payload from 'RequestResponse' service '" + ((HttpRequestWrapper)requestWrapper).getService() + "', but received none."));
                    return null;
                }
                response.setContentLength(0);
                response.setStatus(502);
                logger.debug((Object)("Unsupport HTTP response payload type " + obj.getClass().getName() + " from service '" + ((HttpRequestWrapper)requestWrapper).getService() + "'.  Only supports java.lang.String or byte[] payloads."));
                return null;
            }
            if (outBytes.length > 0) {
                response.getOutputStream().write(outBytes);
            }
            response.setContentLength(outBytes.length);
            if (status != null) {
                response.setStatus(status.intValue());
            } else {
                response.setStatus(200);
            }
        }
        catch (IOException e) {
            throw new MessageDeliverException("Unexpected error when write the message to http response", e);
        }
        return null;
    }

    public Map<String, Object> getRequestInfo(HttpServletRequest request) {
        HashMap<String, Object> requestInfoMap = new HashMap<String, Object>();
        requestInfoMap.put("authType", request.getAuthType());
        requestInfoMap.put("characterEncoding", request.getCharacterEncoding());
        requestInfoMap.put("contentType", request.getContentType());
        requestInfoMap.put("contextPath", request.getContextPath());
        requestInfoMap.put("localAddr", request.getLocalAddr());
        requestInfoMap.put("localName", request.getLocalName());
        requestInfoMap.put("method", request.getMethod());
        requestInfoMap.put("pathInfo", request.getPathInfo());
        requestInfoMap.put("protocol", request.getProtocol());
        requestInfoMap.put("queryString", request.getQueryString());
        requestInfoMap.put("remoteAddr", request.getRemoteAddr());
        requestInfoMap.put("remoteHost", request.getRemoteHost());
        requestInfoMap.put("remoteUser", request.getRemoteUser());
        requestInfoMap.put("contentLength", Integer.toString(request.getContentLength()));
        requestInfoMap.put("requestSessionId", request.getRequestedSessionId());
        requestInfoMap.put("requestURI", request.getRequestURI());
        requestInfoMap.put("scheme", request.getScheme());
        requestInfoMap.put("serverName", request.getServerName());
        requestInfoMap.put("requestPath", request.getServletPath());
        requestInfoMap.put("pathInfo", request.getPathInfo());
        if (request.getPathInfo() != null) {
            requestInfoMap.put("pathInfoTokens", request.getPathInfo().split("/"));
        } else {
            requestInfoMap.put("pathInfoTokens", new String[0]);
        }
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            requestInfoMap.put(name, value);
        }
        return requestInfoMap;
    }
}

