/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.internal.soa.esb.listeners.gateway.filefilter.FileEndsWith;
import org.jboss.internal.soa.esb.listeners.gateway.filefilter.IgnoreFile;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.AbstractFileGateway;
import org.jboss.soa.esb.listeners.gateway.GatewayException;
import org.jboss.soa.esb.listeners.gateway.LocalFileMessageComposer;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.FileUtil;

public class FileGatewayListener
extends AbstractFileGateway {
    private static final long serialVersionUID = 8457176329093772449L;
    private FileFilter _theFilter;
    private String _filterClass = null;

    public FileGatewayListener(ConfigTree config) throws ConfigurationException, RegistryException, GatewayException {
        super(config);
        this._filterClass = config.getAttribute("file-filter-class");
        if (this._filterClass == null) {
            this._theFilter = this._inputSuffix == null || this._inputSuffix.equals("") ? new IgnoreFile(this._workingSuffix, this._errorSuffix, this._postProcessSuffix) : new FileEndsWith(this._inputSuffix);
        } else {
            try {
                Class c = ClassUtil.forName(this._filterClass, this.getClass());
                this._theFilter = (FileFilter)c.newInstance();
                if (this._theFilter instanceof FileFilterInit) {
                    ((FileFilterInit)((Object)this._theFilter)).init(config);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException(ex);
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException(ex);
            }
            catch (ConfigurationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new GatewayException(ex);
            }
        }
    }

    protected void seeIfOkToWorkOnDir(File p_oDir) throws ConfigurationException {
        if (!p_oDir.exists()) {
            throw new ConfigurationException("Directory " + p_oDir.toString() + " not found");
        }
        if (!p_oDir.isDirectory()) {
            throw new ConfigurationException(p_oDir.toString() + " is not a directory");
        }
        if (!p_oDir.canRead()) {
            throw new ConfigurationException("Can't read directory " + p_oDir.toString());
        }
        if (!p_oDir.canWrite()) {
            throw new ConfigurationException("Can't write/rename in directory " + p_oDir.toString());
        }
    }

    boolean deleteFile(File file) throws GatewayException {
        return file.delete();
    }

    byte[] getFileContents(File file) throws GatewayException {
        try {
            int iQread;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] ba = new byte[1000];
            FileInputStream inp = new FileInputStream(file);
            while (-1 != (iQread = inp.read(ba))) {
                if (iQread <= 0) continue;
                out.write(ba, 0, iQread);
            }
            inp.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GatewayException(e);
        }
    }

    File[] getFileList() throws GatewayException {
        return this.filterFiles(this._inputDirectory, this._theFilter);
    }

    private File[] filterFiles(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            _logger.warn((Object)("Error applying file filter '" + filter + "' to directory '" + dir.getAbsolutePath() + "'.  Null file list returned.  Invalid directory, or IO error reading directory."));
        }
        return files;
    }

    boolean renameFile(File from, File to) throws GatewayException {
        return FileUtil.renameTo(from, to);
    }

    String getDefaultComposer() {
        return LocalFileMessageComposer.class.getName();
    }

    void bytesToFile(byte[] bytes, File file) throws GatewayException {
        try {
            if (file.exists() && !file.delete()) {
                throw new GatewayException("Unable to delete existing file " + file);
            }
            FileOutputStream out = new FileOutputStream(file);
            out.write(bytes);
            out.close();
        }
        catch (Exception e) {
            throw new GatewayException(e);
        }
    }

    protected void checkInputSuffix() throws ConfigurationException {
        if (this._inputSuffix == null) {
            this._inputSuffix = "";
        }
    }

    public static interface FileFilterInit {
        public void init(ConfigTree var1) throws ConfigurationException;
    }
}

