/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers110;

import org.apache.xmlbeans.XmlObject;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers110.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers110.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.HttpBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.HttpListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.HttpProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.PropertyDocument;
import org.jboss.soa.esb.listeners.gateway.HttpGatewayListener;
import org.w3c.dom.Element;

public class HttpListenerMapper {
    public static Element map(Element root, HttpListenerDocument.HttpListener listener, XMLBeansModel model) throws ConfigurationException {
        int port;
        HttpProviderDocument.HttpProvider provider;
        HttpBusDocument.HttpBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (HttpBusDocument.HttpBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <http-listener> must reference a <http-bus>.");
        }
        try {
            provider = (HttpProviderDocument.HttpProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <http-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        for (PropertyDocument.Property property : provider.getPropertyList()) {
            Element propertyElement = listenerNode.getOwnerDocument().createElement("property");
            MapperUtil.serialize((XmlObject)property, propertyElement);
            listenerNode.appendChild(propertyElement);
        }
        MapperUtil.mapProperties(bus.getPropertyList(), listenerNode);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            String host = provider.getHost();
            port = provider.getPort();
            listenerNode.setAttribute("gatewayClass", HttpGatewayListener.class.getName());
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            if (host != null) {
                listenerNode.setAttribute("http_host", host);
            }
        } else {
            throw new ConfigurationException("Invalid <http-listener> config [" + listener.getName() + "]. <http-listener> is currently only supported as a gateway listener.");
        }
        listenerNode.setAttribute("http_context", bus.getContext());
        listenerNode.setAttribute("http_port", Integer.toString(port));
        return listenerNode;
    }
}

