/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Provider;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.impl.BusImpl;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.impl.BusProviderImpl;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.impl.ListenerImpl;
import org.w3c.dom.Element;

public class UntypedListenerMapper {
    public static Element map(Element root, Listener listener, XMLBeansModel model) throws ConfigurationException {
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        UntypedListenerMapper.assertListenerConfigOK(listener, model);
        MapperUtil.mapDefaultAttributes(listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            MapperUtil.mapEPRProperties(listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            MapperUtil.mapEPRProperties(listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void assertListenerConfigOK(Listener listener, XMLBeansModel model) throws ConfigurationException {
        if (listener.getClass() != ListenerImpl.class) {
            throw new ConfigurationException("Can only use the " + UntypedListenerMapper.class.getName() + " mapper on the base listener type.  Cannot use on " + listener.getClass().getName());
        }
        Bus bus = model.getBus(listener.getBusidref());
        if (bus.getClass() != BusImpl.class) {
            throw new ConfigurationException("The base Listener config [" + listener.getName() + "] must reference a base Bus config type (<bus>).");
        }
        Provider provider = model.getProvider(bus);
        if (provider.getClass().isAssignableFrom(BusProviderImpl.class)) {
            throw new ConfigurationException("A base Bus config type (<bus>) must be contained within a base Provider type (<bus-provider>).");
        }
    }
}

