/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.internal.soa.esb.listeners.war.Filter;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.listeners.war.WebDeploymentArchive;
import org.jboss.internal.soa.esb.listeners.war.WebModel;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.publish.DefaultContractReferencePublisher;
import org.jboss.internal.soa.esb.util.JBossDeployerUtil;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.internal.soa.esb.webservice.ESBContractGenerator;
import org.jboss.internal.soa.esb.webservice.ESBResponseFilter;
import org.jboss.internal.soa.esb.webservice.ESBServiceContractReferencePublisher;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.internal.soa.esb.webservice.JAXWSProviderClassGenerator;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeployerMBean;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeployment;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeploymentMetaData;
import org.jboss.soa.esb.listeners.config.ModelUtil;
import org.jboss.soa.esb.listeners.config.ServiceContract;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.util.DeploymentArchive;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.system.ServiceControllerMBean;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss4ESBDeployer
extends SubDeployerSupport
implements SubDeployer,
JBoss4ESBDeployerMBean {
    private static final Logger log = Logger.getLogger(JBoss4ESBDeployer.class);
    private ServiceControllerMBean serviceController;
    private Properties actionArtifactProperties;
    private File esbWarFiles;
    private final Set<String> esbNames = new HashSet<String>();
    private static final String PREFIX_CANONICAL_NAME = "jboss.esb:deployment=";
    private static final String ESB_ARTIFACT_NAME = "jbossesb.esb";
    private static final String SUB_DEPLOYMENTS = JBoss4ESBDeployer.class.getName() + "#SUB_DEPLOYMENTS";
    private String warFilesDir;

    public JBoss4ESBDeployer() {
        this.setSuffixes(new String[]{".esb"});
        this.setRelativeOrder(1000);
    }

    public static boolean hasFile(DeploymentInfo di, String filePath) {
        String urlStr = di.url.getFile();
        try {
            URL dd = di.localCl.findResource(filePath);
            if (dd != null) {
                String ddStr;
                if (di.localUrl != null) {
                    urlStr = di.localUrl.toString();
                }
                if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith(".esb") || urlStr.endsWith(".esb/") || urlStr.endsWith("-esb.xml");
    }

    protected void startService() throws Exception {
        this.actionArtifactProperties = JBossDeployerUtil.getArtifactProperties("/actionArtifactMap.properties");
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.mainDeployer.addDeployer((SubDeployer)this);
        LifecycleResourceManager.deactivateHook();
    }

    protected void stopService() throws Exception {
        LifecycleResourceManager.getSingleton().cleanupAllResources();
        super.stopService();
    }

    protected URL getDocumentUrl(DeploymentInfo di) {
        String urlStr = di.url.toString();
        if (urlStr.endsWith(".esb") || urlStr.endsWith(".esb/")) {
            return di.localCl.getResource("META-INF/jboss-esb.xml");
        }
        return di.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DeploymentInfo di) throws DeploymentException {
        if (this.warFilesDir == null) {
            String errorMsg = String.format("No property named '%s' was configured in jbossesb.sar/META-INF/jboss-service.xml for %s", "warFilesDir", this.getClass().getName());
            throw new DeploymentException(errorMsg);
        }
        File tmpDir = new File(this.warFilesDir);
        if (!tmpDir.exists()) {
            String errorMsg = String.format("The directory configured for %s='%s' does not exist.", "warFilesDir", tmpDir);
            throw new DeploymentException(errorMsg);
        }
        this.esbWarFiles = JBossDeployerUtil.createDir(tmpDir, "esbwarfiles");
        try {
            URL document;
            File file;
            di.watch = di.url.getProtocol().equalsIgnoreCase("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/jboss-esb.xml")) : di.url;
            XmlFileLoader xfl = new XmlFileLoader();
            InputStream in = di.localCl.getResourceAsStream("META-INF/deployment.xml");
            if (in != null) {
                try {
                    Element jboss = xfl.getDocument(in, "META-INF/deployment.xml").getDocumentElement();
                    Element loader = MetaData.getOptionalChild((Element)jboss, (String)"loader-repository");
                    if (loader != null) {
                        LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
                        di.setRepositoryInfo(config);
                    }
                }
                finally {
                    in.close();
                }
            }
            if ((document = this.getDocumentUrl(di)) == null) {
                throw new DeploymentException("Unable to find document url of META-INF/jboss-esb.xml in: " + di.url);
            }
            String jbossEsbXml = JBossDeployerUtil.readEsbConfig(document.openStream());
            HashSet<ObjectName> deps = new HashSet<ObjectName>();
            ModelAdapter model = JBossDeployerUtil.getJbossEsbModel(jbossEsbXml);
            this.addActionDependencies(di.shortName, model, deps);
            JBoss4ESBDeployment deployment = new JBoss4ESBDeployment(jbossEsbXml, di.shortName);
            this.initialiseDeploymentName(deployment);
            String deploymentName = deployment.getDeploymentName();
            di.context.put(JBoss4ESBDeploymentMetaData.class, new JBoss4ESBDeploymentMetaData(deployment, deploymentName, deps));
            di.context.put(SUB_DEPLOYMENTS, new ArrayList());
            super.init(di);
            ClassLoader origCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(di.localCl);
                this.deployWebGateways(deployment, model, di);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origCL);
            }
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException("failed to initialize", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void create(DeploymentInfo di) throws DeploymentException {
        log.info((Object)("create esb service, " + di.shortName));
        try {
            String name;
            ObjectName on;
            JBoss4ESBDeploymentMetaData metaData = (JBoss4ESBDeploymentMetaData)di.context.get(JBoss4ESBDeploymentMetaData.class);
            Set<ObjectName> deps = metaData.getDependencies();
            InputStream in = di.localCl.getResourceAsStream("META-INF/deployment.xml");
            if (in != null) {
                try {
                    Iterator esbDepends;
                    XmlFileLoader xfl = new XmlFileLoader();
                    Element jboss = xfl.getDocument(in, "META-INF/deployment.xml").getDocumentElement();
                    Iterator depends = MetaData.getChildrenByTagName((Element)jboss, (String)"depends");
                    if (depends != null) {
                        while (depends.hasNext()) {
                            Element depend = (Element)depends.next();
                            ObjectName depOn = new ObjectName(MetaData.getElementContent((Element)depend));
                            deps.add(depOn);
                        }
                    }
                    if ((esbDepends = MetaData.getChildrenByTagName((Element)jboss, (String)"esb-depends")) != null && esbDepends.hasNext()) {
                        HashMap<String, DeploymentInfo> subDeploymentLocationMap;
                        if (di.subDeployments.size() > 0) {
                            subDeploymentLocationMap = new HashMap<String, DeploymentInfo>();
                            Set subDeployments = di.subDeployments;
                            for (DeploymentInfo subDI : subDeployments) {
                                String urlPath = subDI.url.getPath();
                                String deployablePath = urlPath.endsWith("/") ? urlPath.substring(0, urlPath.length() - 1) : urlPath;
                                int lastSeparator = deployablePath.lastIndexOf(47);
                                String deployable = lastSeparator >= 0 ? deployablePath.substring(lastSeparator + 1) : deployablePath;
                                if (subDeploymentLocationMap.put(deployable, subDI) == null) continue;
                                throw new DeploymentException("Duplicate subDeployment name: " + deployable);
                            }
                        } else {
                            throw new DeploymentException("No subdeployments to match esb-depends");
                        }
                        do {
                            Element depend;
                            String deployable;
                            DeploymentInfo subDI;
                            if ((subDI = (DeploymentInfo)subDeploymentLocationMap.get(deployable = MetaData.getElementContent((Element)(depend = (Element)esbDepends.next())))) == null || !subDI.context.containsKey("org.jboss.web.AbstractWebContainer.webModule")) {
                                throw new DeploymentException("Could not locate WAR subdeployment matching: " + deployable);
                            }
                            ObjectName jmxName = (ObjectName)subDI.context.get("org.jboss.web.AbstractWebContainer.webModule");
                            deps.add(jmxName);
                        } while (esbDepends.hasNext());
                    }
                }
                finally {
                    in.close();
                }
            }
            if (this.server.isRegistered(on = ObjectNameConverter.convert((String)(name = PREFIX_CANONICAL_NAME + metaData.getDeploymentName())))) {
                throw new DeploymentException("Duplicate registration for " + name);
            }
            JBoss4ESBDeployment deployment = metaData.getDeployment();
            deployment.setClassloader((ClassLoader)di.ucl);
            this.server.registerMBean(deployment, on);
            di.deployedObject = on;
            log.debug((Object)("Deploying: " + di.url));
            this.serviceController.create(di.deployedObject, deps);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during create of ESB Module: " + di.url, (Throwable)e);
        }
        super.create(di);
    }

    private void addActionDependencies(String deploymentName, ModelAdapter model, Set<ObjectName> deps) throws MalformedObjectNameException {
        int numActionClasses;
        HashSet<String> artifacts = new HashSet<String>();
        artifacts.add(ESB_ARTIFACT_NAME);
        Set<String> actionClasses = model.getActions();
        int n = numActionClasses = actionClasses == null ? 0 : actionClasses.size();
        if (numActionClasses > 0) {
            for (String actionClass : actionClasses) {
                String artifact = (String)this.actionArtifactProperties.get(actionClass);
                if (artifact == null) continue;
                artifacts.add(artifact);
            }
        }
        for (String artifact : artifacts) {
            if (deploymentName.equals(artifact)) continue;
            String canonicalName = PREFIX_CANONICAL_NAME + artifact;
            ObjectName on = ObjectNameConverter.convert((String)canonicalName);
            deps.add(on);
        }
    }

    private void createWebserviceWars(DeploymentInfo di, ModelAdapter model, String deploymentName, List<ContractReferencePublisher> publishers, WebDeploymentArchive webDeployment) throws DeploymentException {
        List<WebserviceInfo> endpointServices = model.getWebserviceServices();
        if (endpointServices != null && endpointServices.size() > 0) {
            try {
                JAXWSProviderClassGenerator generator = new JAXWSProviderClassGenerator();
                for (WebserviceInfo webserviceInfo : endpointServices) {
                    boolean includeHandlers;
                    Service service = webserviceInfo.getService();
                    File esbArchive = new File(di.watch.getFile());
                    Map<String, String> schemasMap = JBoss4ESBDeployer.getSchemas(esbArchive);
                    String wsdlDir = "WEB-INF/wsdl/" + service.getCategory().replace('/', '_') + "/";
                    for (Map.Entry<String, String> schemaEntry : schemasMap.entrySet()) {
                        webDeployment.addEntry(wsdlDir + schemaEntry.getKey(), schemaEntry.getValue().getBytes("UTF-8"));
                        log.debug((Object)("Added schema " + wsdlDir + schemaEntry.getKey()));
                    }
                    ESBServiceEndpointInfo serviceInfo = new ESBServiceEndpointInfo(webserviceInfo);
                    String wsdl = ESBContractGenerator.generateWSDL(webserviceInfo, serviceInfo);
                    webDeployment.addEntry(serviceInfo.getWSDLFileName(), wsdl.getBytes("UTF-8"));
                    String handlers = JBossDeployerUtil.getHandlers(serviceInfo);
                    boolean bl = includeHandlers = handlers != null;
                    if (includeHandlers) {
                        String wsHandlerName = "WEB-INF/classes/" + serviceInfo.getPackageName().replace('.', '/') + "/esb-jaxws-handlers.xml";
                        webDeployment.addEntry(wsHandlerName, handlers.getBytes("UTF-8"));
                    }
                    byte[] wsClass = generator.generate(service.getCategory(), service.getName(), serviceInfo, includeHandlers);
                    String wsClassName = serviceInfo.getClassName().replace('.', '/') + ".class";
                    webDeployment.addEntry("WEB-INF/classes/" + wsClassName, wsClass);
                    Servlet servlet = new Servlet(serviceInfo.getServletName(), serviceInfo.getClassName(), webDeployment.getWebModel());
                    servlet.getUrlMappings().add("/ebws" + serviceInfo.getServletPath());
                    if (serviceInfo.isOneWay()) {
                        new Filter(serviceInfo.getServletName() + "_Filter", ESBResponseFilter.class.getName(), servlet);
                    }
                    ESBServiceContractReferencePublisher publisher = new ESBServiceContractReferencePublisher(service, webserviceInfo.getDescription(), serviceInfo.getServletName());
                    publishers.add(publisher);
                }
            }
            catch (Exception ex) {
                throw new DeploymentException("Failed to create webservice artifact", (Throwable)ex);
            }
        }
    }

    private void deployWebGateways(JBoss4ESBDeployment deployment, ModelAdapter model, DeploymentInfo di) throws ConfigurationException, DeploymentException, JMException {
        String deploymentName = deployment.getDeploymentName();
        ArrayList<ContractReferencePublisher> publishers = new ArrayList<ContractReferencePublisher>();
        WebDeploymentArchive webDeployment = new WebDeploymentArchive(this.getESBWarFileName(di));
        WebModel webModel = webDeployment.getWebModel();
        webModel.setAuthDomain(model.getAuthDomain());
        webModel.setAuthMethod(model.getAuthMethod());
        this.createWebserviceWars(di, model, deploymentName, publishers, webDeployment);
        ModelUtil.updateWebModel(ModelUtil.getListenerGroups(model), webModel);
        if (!webModel.getServlets().isEmpty()) {
            List<ServiceContract> modelServiceContracts = model.getServiceContracts();
            if (modelServiceContracts != null && modelServiceContracts.size() > 0) {
                ArrayList<ServiceContract> actionableServiceContracts = new ArrayList<ServiceContract>();
                block2: for (Servlet servlet : webModel.getServlets()) {
                    Service service = servlet.getService();
                    String endpointAddress = servlet.getEndpointAddress();
                    if (service == null || endpointAddress == null) continue;
                    for (ServiceContract serviceContract : modelServiceContracts) {
                        if (!service.equals(serviceContract.getService())) continue;
                        actionableServiceContracts.add(serviceContract);
                        publishers.add(new DefaultContractReferencePublisher(service, serviceContract.getDescription(), endpointAddress));
                        continue block2;
                    }
                }
                deployment.setServiceContracts(actionableServiceContracts);
            }
            webDeployment.finalizeArchive();
            File file = this.createGatewayTempDeployment(webDeployment, di);
            try {
                this.deployUrl(di, file.toURL(), webDeployment.getArchiveName());
                this.getSubDeployments(di).add(file);
            }
            catch (Throwable throwable) {
                if (file.exists()) {
                    file.delete();
                }
                throw new ConfigurationException("Error deploying '" + file.getAbsolutePath() + "'.", throwable);
            }
            deployment.setPublishers(publishers);
        }
    }

    private File createGatewayTempDeployment(DeploymentArchive deploymentArchive, DeploymentInfo di) throws ConfigurationException {
        FileOutputStream fileOutStream;
        File gatewayDeployFile = this.createTempDeploymentFile(this.esbWarFiles, deploymentArchive.getArchiveName(), true);
        try {
            fileOutStream = new FileOutputStream(gatewayDeployFile);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Unexpected exception.", e);
        }
        try {
            deploymentArchive.toOutputStream(fileOutStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing deployment archive '" + gatewayDeployFile.getAbsolutePath() + "'.", e);
        }
        finally {
            try {
                fileOutStream.close();
            }
            catch (IOException e) {
                log.warn((Object)("Error closing deployment archive stream '" + gatewayDeployFile.getAbsolutePath() + "'"), (Throwable)e);
            }
        }
        return gatewayDeployFile;
    }

    private File createTempDeploymentFile(File tempDir, String archiveName, boolean createDir) throws ConfigurationException {
        File file;
        if (!tempDir.exists()) {
            if (!createDir) {
                return null;
            }
            tempDir.mkdir();
        }
        if ((file = new File(tempDir, archiveName)).exists()) {
            log.debug((Object)("Deployment archive '" + archiveName + "' already exists.  Overwriting!!"));
        }
        return file;
    }

    private String getESBWarFileName(DeploymentInfo di) {
        String esbName = di.shortName;
        int lastSeparator = esbName.lastIndexOf(46);
        return (lastSeparator >= 0 ? esbName.substring(0, lastSeparator) : esbName) + ".war";
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.start(di.deployedObject);
        }
        catch (Exception e) {
            try {
                this.stop(di);
                this.destroy(di);
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
            throw new DeploymentException("Error during start of ESB Module: " + di.url, (Throwable)e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        if (di.deployedObject != null) {
            try {
                this.serviceController.stop(di.deployedObject);
            }
            catch (Exception e) {
                throw new DeploymentException("Error during stop of ESB Module: " + di.url, (Throwable)e);
            }
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        JBoss4ESBDeploymentMetaData metaData = (JBoss4ESBDeploymentMetaData)di.context.get(JBoss4ESBDeploymentMetaData.class);
        for (File subDeployment : this.getSubDeployments(di)) {
            try {
                if (!subDeployment.exists() || subDeployment.delete()) continue;
                log.debug((Object)("Failed to delete sub deployment '" + subDeployment.getAbsolutePath() + "'."));
            }
            catch (Exception e) {
                log.debug((Object)("Failed to delete deployment file '" + subDeployment.getAbsolutePath() + "'.  Exception: " + e.getMessage()));
            }
        }
        if (metaData != null) {
            String deploymentName = metaData.getDeploymentName();
            this.removeDeploymentName(deploymentName);
        }
        if (di.deployedObject != null) {
            try {
                this.serviceController.destroy(di.deployedObject);
                this.server.unregisterMBean(di.deployedObject);
            }
            catch (Exception e) {
                throw new DeploymentException("Error during stop of ESB Module: " + di.url, (Throwable)e);
            }
        }
        super.destroy(di);
    }

    private synchronized void initialiseDeploymentName(JBoss4ESBDeployment deployment) {
        String deploymentName = deployment.getDeploymentName();
        if (!this.esbNames.add(deploymentName)) {
            deployment.setDeploymentName(deploymentName + ",uid=" + System.identityHashCode(deployment));
        }
    }

    private synchronized void removeDeploymentName(String deploymentName) {
        this.esbNames.remove(deploymentName);
    }

    private List<File> getSubDeployments(DeploymentInfo di) {
        return (List)di.context.get(SUB_DEPLOYMENTS);
    }

    @Override
    public void setWarFilesDir(String dir) {
        this.warFilesDir = dir;
    }

    static Map<String, String> getSchemas(File file) throws DeploymentException {
        if (file == null) {
            return Collections.emptyMap();
        }
        if (file.isDirectory()) {
            return JBoss4ESBDeployer.getSchemasFromDirectory(file);
        }
        return JBoss4ESBDeployer.getSchemasFromArchive(file);
    }

    static Map<String, String> getSchemasFromDirectory(File directory) throws DeploymentException {
        File[] schemas;
        if (directory != null && directory.isDirectory() && (schemas = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return JBoss4ESBDeployer.isXsd(name);
            }
        })).length > 0) {
            HashMap<String, String> schemasMap = new HashMap<String, String>();
            for (File file : schemas) {
                try {
                    schemasMap.put(file.getName(), FileUtil.readTextFile(file));
                }
                catch (IOException e) {
                    throw new DeploymentException("IOException while trying to read xsd '" + file.getName() + "'", (Throwable)e);
                }
            }
            return schemasMap;
        }
        return Collections.emptyMap();
    }

    private static boolean isXsd(String fileName) {
        return fileName.endsWith(".xsd");
    }

    static Map<String, String> getSchemasFromArchive(File archive) throws DeploymentException {
        if (archive == null || !archive.isFile() || !archive.getName().endsWith(".esb")) {
            return Collections.emptyMap();
        }
        HashMap<String, String> schemas = new HashMap<String, String>();
        ZipFile zip = JBoss4ESBDeployer.getZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String fileName = entry.getName();
            if (!JBoss4ESBDeployer.isXsd(fileName)) continue;
            InputStream in = null;
            try {
                in = zip.getInputStream(entry);
                schemas.put(fileName, StreamUtils.readStreamString(in, "UTF-8"));
            }
            catch (IOException e) {
                throw new DeploymentException("IOException while trying to read from file '" + fileName + "' from archive '" + archive + "'", (Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    log.error((Object)("Error while trying to close in stream for file '" + fileName + "'"), (Throwable)ignore);
                }
            }
        }
        return schemas;
    }

    private static ZipFile getZipFile(File archive) throws DeploymentException {
        try {
            return new ZipFile(archive);
        }
        catch (ZipException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }
}

