/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaResolver
implements LSResourceResolver {
    private Logger log = Logger.getLogger(SchemaResolver.class);
    private final String encoding;
    private final URI parentSchemaUri;

    public SchemaResolver(URI baseUri) {
        this("UTF-8", baseUri);
    }

    public SchemaResolver(String encoding, URI baseUri) {
        AssertArgument.isNotNullAndNotEmpty(encoding, "encoding");
        AssertArgument.isNotNull(baseUri, "baseUri");
        this.encoding = encoding;
        this.parentSchemaUri = baseUri;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        URI resolvedUri;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("parentSchemaUri='%s', systemId='%s', baseURI='%s'", this.parentSchemaUri, systemId, baseURI));
        }
        LSInputImpl inputImpl = new LSInputImpl();
        if (baseURI != null) {
            URI uri = URI.create(baseURI);
            this.log.debug((Object)("Try to resolve " + uri + "/" + systemId));
            resolvedUri = uri.resolve(systemId);
        } else {
            resolvedUri = this.parentSchemaUri.resolve(systemId);
        }
        this.log.debug((Object)("Resolved Schema '" + resolvedUri + "'"));
        inputImpl.setSystemId(resolvedUri.toString());
        inputImpl.setCharacterStream(this.getReader(resolvedUri));
        return inputImpl;
    }

    private Reader getReader(URI resolvedUri) {
        String scheme = resolvedUri.getScheme();
        if (resolvedUri.isAbsolute()) {
            if (scheme.equals("file")) {
                try {
                    InputStream in = this.getFileInputStream(resolvedUri);
                    return new StringReader(StreamUtils.readStreamString(in, this.encoding));
                }
                catch (FileNotFoundException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if (scheme.equals("classpath")) {
                InputStream in = ClassUtil.getResourceAsStream(resolvedUri.getPath(), this.getClass());
                if (in != null) {
                    try {
                        return new StringReader(StreamUtils.readStreamString(in, this.encoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.log.info((Object)("Could not read resource : " + resolvedUri.getPath()));
                }
            }
        }
        return null;
    }

    private InputStream getFileInputStream(URI uri) throws FileNotFoundException {
        File file = new File(uri);
        if (file.exists() && !file.isDirectory()) {
            return new FileInputStream(file);
        }
        throw new FileNotFoundException("Could not locate '" + uri + "' on local filesystem");
    }

    private class LSInputImpl
    implements LSInput {
        private String publicId;
        private String systemId;
        private String baseUri;
        private Reader reader;

        public Reader getCharacterStream() {
            return this.reader;
        }

        public InputStream getByteStream() {
            return null;
        }

        public String getStringData() {
            return null;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public String getBaseURI() {
            return this.baseUri;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getEncoding() {
            return SchemaResolver.this.encoding;
        }

        public boolean getCertifiedText() {
            return false;
        }

        public void setBaseURI(String baseURI) {
            this.baseUri = baseURI;
        }

        public void setByteStream(InputStream byteStream) {
        }

        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException("setCertifiedText is not supported");
        }

        public void setCharacterStream(Reader characterStream) {
            this.reader = characterStream;
        }

        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException("setEncoding is not supported");
        }

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public void setStringData(String stringData) {
            throw new UnsupportedOperationException("setStringData is not supported");
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

