/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.registry.AbstractRegistryInterceptor;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingRegistryInterceptor
extends AbstractRegistryInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CachingRegistryInterceptor.class);
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private static final long DEFAULT_VALIDITY_PERIOD = 600000L;
    private static final int MAX_CACHE_SIZE;
    private static final long VALIDITY_PERIOD;
    private final LRUMap serviceInfoMap = new LRUMap(MAX_CACHE_SIZE);

    @Override
    public List<String> findAllServices() throws RegistryException {
        return this.getRegistry().findAllServices();
    }

    @Override
    public List<String> findServices(String category) throws RegistryException {
        return this.getRegistry().findServices(category);
    }

    @Override
    public EPR findEPR(String category, String name) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        ConcurrentMap<EPR, AtomicLong> eprs = this.getEPRs(service);
        Iterator eprIter = eprs.keySet().iterator();
        if (eprIter.hasNext()) {
            return (EPR)eprIter.next();
        }
        return null;
    }

    @Override
    public List<EPR> findEPRs(String category, String name) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        ConcurrentMap<EPR, AtomicLong> eprs = this.getEPRs(service);
        return Arrays.asList(eprs.keySet().toArray(new EPR[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEPR(String category, String name, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        Service service = new Service(category, name);
        ServiceInfo serviceInfo = this.getServiceInfo(service);
        if (serviceInfo != null) {
            serviceInfo.acquireWriteLock();
        }
        try {
            ConcurrentMap<EPR, AtomicLong> eprs;
            this.getRegistry().registerEPR(category, name, serviceDescription, epr, eprDescription);
            if (serviceInfo != null && (eprs = serviceInfo.getEPRs()) != null) {
                CachingRegistryInterceptor.addEPR(eprs, epr);
            }
        }
        finally {
            if (serviceInfo != null) {
                serviceInfo.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterEPR(String category, String name, EPR epr) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        ServiceInfo serviceInfo = this.getServiceInfo(service);
        if (serviceInfo != null) {
            serviceInfo.acquireWriteLock();
        }
        try {
            AtomicLong count;
            ConcurrentMap<EPR, AtomicLong> eprs;
            this.getRegistry().unRegisterEPR(category, name, epr);
            if (serviceInfo != null && (eprs = serviceInfo.getEPRs()) != null && (count = (AtomicLong)eprs.get(epr)) != null && count.decrementAndGet() == 0L) {
                eprs.remove(epr);
            }
        }
        finally {
            if (serviceInfo != null) {
                serviceInfo.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterService(String category, String name) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        ServiceInfo serviceInfo = this.getServiceInfo(service);
        if (serviceInfo != null) {
            serviceInfo.acquireWriteLock();
        }
        try {
            this.getRegistry().unRegisterService(category, name);
            this.removeServiceInfo(service);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cache removing service " + service));
            }
        }
        finally {
            if (serviceInfo != null) {
                serviceInfo.releaseWriteLock();
            }
        }
    }

    private synchronized ServiceInfo getServiceInfo(Service service) {
        ServiceInfo serviceInfo = (ServiceInfo)this.serviceInfoMap.get((Object)service);
        if (serviceInfo != null) {
            if (serviceInfo.isValid()) {
                return serviceInfo;
            }
            this.removeServiceInfo(service);
        }
        return null;
    }

    private synchronized ServiceInfo createServiceInfo(Service service) {
        ServiceInfo serviceInfo = new ServiceInfo();
        ServiceInfo origServiceInfo = (ServiceInfo)this.serviceInfoMap.put((Object)service, (Object)serviceInfo);
        if (origServiceInfo != null && origServiceInfo.isValid()) {
            this.serviceInfoMap.put((Object)service, (Object)origServiceInfo);
            return origServiceInfo;
        }
        return serviceInfo;
    }

    private synchronized void removeServiceInfo(Service service) {
        this.serviceInfoMap.remove((Object)service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<EPR, AtomicLong> getEPRs(Service service) throws RegistryException, ServiceNotFoundException {
        ServiceInfo serviceInfo = this.getServiceInfo(service);
        if (serviceInfo != null) {
            serviceInfo.acquireReadLock();
            try {
                ConcurrentMap<EPR, AtomicLong> eprs = serviceInfo.getEPRs();
                if (eprs != null) {
                    ConcurrentMap<EPR, AtomicLong> concurrentMap = eprs;
                    return concurrentMap;
                }
            }
            finally {
                serviceInfo.releaseReadLock();
            }
        }
        ServiceInfo newServiceInfo = this.createServiceInfo(service);
        newServiceInfo.acquireWriteLock();
        try {
            ConcurrentMap<EPR, AtomicLong> eprs = newServiceInfo.getEPRs();
            if (eprs != null) {
                ConcurrentMap<EPR, AtomicLong> concurrentMap = eprs;
                return concurrentMap;
            }
            List<EPR> currentEPRs = this.getRegistry().findEPRs(service.getCategory(), service.getName());
            ConcurrentHashMap<EPR, AtomicLong> newEPRs = new ConcurrentHashMap<EPR, AtomicLong>();
            for (EPR epr : currentEPRs) {
                CachingRegistryInterceptor.addEPR(newEPRs, epr);
            }
            newServiceInfo.setEPRs(newEPRs);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cache reloaded for service " + service));
            }
            ConcurrentHashMap<EPR, AtomicLong> concurrentHashMap = newEPRs;
            return concurrentHashMap;
        }
        finally {
            newServiceInfo.releaseWriteLock();
        }
    }

    private static void addEPR(ConcurrentMap<EPR, AtomicLong> eprs, EPR epr) {
        AtomicLong newCount = new AtomicLong(1L);
        AtomicLong count = eprs.putIfAbsent(epr, newCount);
        if (count != null) {
            count.incrementAndGet();
        }
    }

    static {
        String maxCacheSizeVal = Configuration.getRegistryCacheMaxSize();
        int maxCacheSize = 100;
        if (maxCacheSizeVal != null) {
            try {
                maxCacheSize = Integer.parseInt(maxCacheSizeVal);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn((Object)"Failed to parse maximum cache size, falling back to default", (Throwable)nfe);
            }
        }
        String validityPeriodVal = Configuration.getRegistryCacheValidityPeriod();
        long validityPeriod = 600000L;
        if (validityPeriodVal != null) {
            try {
                validityPeriod = Long.parseLong(validityPeriodVal);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn((Object)"Failed to parse validity period, falling back to default", (Throwable)nfe);
            }
        }
        VALIDITY_PERIOD = validityPeriod;
        MAX_CACHE_SIZE = maxCacheSize;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Registry cache validity period: " + VALIDITY_PERIOD));
            LOGGER.debug((Object)("Registry cache maximum size: " + MAX_CACHE_SIZE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceInfo {
        private final long expiryTime;
        private ConcurrentMap<EPR, AtomicLong> eprs;
        private ReadWriteLock lock = new ReentrantReadWriteLock();

        private ServiceInfo() {
            this.expiryTime = VALIDITY_PERIOD > 0L ? System.currentTimeMillis() + VALIDITY_PERIOD : Long.MAX_VALUE;
        }

        boolean isValid() {
            return System.currentTimeMillis() < this.expiryTime;
        }

        ConcurrentMap<EPR, AtomicLong> getEPRs() {
            return this.eprs;
        }

        void setEPRs(ConcurrentMap<EPR, AtomicLong> eprs) {
            this.eprs = eprs;
        }

        void acquireWriteLock() {
            this.lock.writeLock().lock();
        }

        void releaseWriteLock() {
            this.lock.writeLock().unlock();
        }

        void acquireReadLock() {
            this.lock.readLock().lock();
        }

        void releaseReadLock() {
            this.lock.readLock().unlock();
        }
    }
}

