/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;

class JmsXASession
extends JmsSession
implements Synchronization {
    private final JmsConnectionPool pool;
    private final XASession session;
    private boolean associated;
    private Cleanup cleanupAction = Cleanup.none;

    JmsXASession(JmsConnectionPool pool, XASession session, long id, int requestedAcknowledgeMode) throws JMSException {
        super(pool, (Session)session, id, requestedAcknowledgeMode);
        this.pool = pool;
        this.session = (XASession)this.getExceptionHandler(pool, XASession.class, session);
    }

    public void commit() throws JMSException {
    }

    public void rollback() throws JMSException {
        try {
            TransactionStrategy.getTransactionStrategy(true).rollbackOnly();
        }
        catch (TransactionStrategyException tse) {
            JMSException ex = new JMSException("Failed to rollback transaction");
            ex.initCause((Throwable)tse);
            throw ex;
        }
    }

    protected MessageProducer getMessageProducer(MessageProducer messageProducer) {
        AssociationHandler handler = new AssociationHandler(messageProducer);
        return (MessageProducer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MessageProducer.class}, (InvocationHandler)handler);
    }

    protected MessageConsumer getMessageConsumer(MessageConsumer messageConsumer) {
        AssociationHandler handler = new AssociationHandler(messageConsumer);
        return (MessageConsumer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MessageConsumer.class}, (InvocationHandler)handler);
    }

    protected QueueBrowser getQueueBrowser(QueueBrowser queueBrowser) {
        AssociationHandler handler = new AssociationHandler(queueBrowser);
        return (QueueBrowser)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{QueueBrowser.class}, (InvocationHandler)handler);
    }

    protected TopicSubscriber getTopicSubscriber(TopicSubscriber topicSubscriber) {
        AssociationHandler handler = new AssociationHandler(topicSubscriber);
        return (TopicSubscriber)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TopicSubscriber.class}, (InvocationHandler)handler);
    }

    protected synchronized void handleCloseSession(JmsConnectionPool jmsConnectionPool) {
        if (this.associated) {
            this.cleanupAction = Cleanup.close;
        } else {
            this.pool.handleCloseSession(this);
        }
    }

    protected synchronized void handleReleaseSession(JmsConnectionPool jmsConnectionPool) {
        if (this.associated) {
            this.cleanupAction = Cleanup.release;
        } else {
            this.pool.handleReleaseSession(this);
        }
    }

    protected synchronized void associate() throws JMSException {
        if (!this.associated) {
            this.cleanupAction = Cleanup.none;
            TransactionStrategy transactionStrategy = TransactionStrategy.getTransactionStrategy(true);
            try {
                transactionStrategy.registerSynchronization(this);
                this.setSuspect(true);
                XAResource resource = this.session.getXAResource();
                transactionStrategy.enlistResource(resource);
            }
            catch (TransactionStrategyException tse) {
                JMSException ex = new JMSException("Failed to initialise transaction resources");
                ex.initCause((Throwable)tse);
                throw ex;
            }
            try {
                this.pool.associateTransaction(this);
            }
            catch (ConnectionException ce) {
                JMSException ex = new JMSException("Failed to associate session with the current transaction");
                ex.initCause((Throwable)ce);
                throw ex;
            }
            this.setSuspect(false);
            this.associated = true;
        }
    }

    public void beforeCompletion() {
    }

    public synchronized void afterCompletion(int result) {
        this.pool.disassociateTransaction(this);
        switch (this.cleanupAction) {
            case close: {
                if (result == 3) {
                    this.pool.handleCloseSession(this);
                    break;
                }
            }
            case release: {
                this.pool.handleReleaseSession(this);
                break;
            }
        }
        this.associated = false;
    }

    private final class AssociationHandler
    implements InvocationHandler {
        private final Object target;

        public AssociationHandler(Object target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            JmsXASession.this.associate();
            try {
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Cleanup {
        close,
        release,
        none;

    }
}

