/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.serialized;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;
import org.jboss.internal.soa.esb.message.format.serialized.MessageImpl;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ContextObjectInputStream;

public class JavaMessageSerializer
extends MessageSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Message message, OutputStream outStream) throws IOException {
        this.assertMessageInstanceOK(message);
        outStream.write(1);
        ObjectOutputStream output = new ObjectOutputStream(outStream);
        try {
            output.writeObject(message);
        }
        finally {
            output.close();
        }
    }

    public Message deserialize(InputStream inStream) throws IOException {
        if (inStream.read() != 1) {
            throw new IOException("Cannot deserialize message.  Unrecognized message preamble.");
        }
        ContextObjectInputStream input = new ContextObjectInputStream(inStream);
        try {
            Message message = (Message)input.readObject();
            return message;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Unable to deserialize message instance.").initCause(e);
        }
        finally {
            input.close();
        }
    }

    public static boolean isJavaMessage(Message message) {
        return message instanceof MessageImpl;
    }

    private void assertMessageInstanceOK(Message message) throws IOException {
        if (!JavaMessageSerializer.isJavaMessage(message)) {
            throw new IOException("Invalid Message instance.  Expecting instance of '" + MessageImpl.class.getName() + "'.");
        }
    }
}

