/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LegacyMessageComposerAdapter<T>
implements MessageComposer<T> {
    protected Class _composerClass;
    protected Object _composer;
    protected Method _processMethod;
    protected Method _responderMethod;
    private ConfigTree config;

    @Override
    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        this.config = config;
        this.resolveComposerClass();
    }

    public boolean hasResponder() {
        return this._responderMethod != null;
    }

    public abstract Class[] getResponderParameters();

    @Override
    public Message compose(T messagePayload) throws MessageDeliverException {
        try {
            return (Message)this._processMethod.invoke(this._composer, messagePayload);
        }
        catch (ClassCastException e) {
            throw new MessageDeliverException("Legacy composer class ('" + this._composerClass.getName() + "') process method '" + this._processMethod.getName() + "' must return an ESB Message (" + Message.class.getName() + ").");
        }
        catch (IllegalAccessException e) {
            throw new MessageDeliverException("Legacy composer class ('" + this._composerClass.getName() + "') process method '" + this._processMethod.getName() + "' is not callable.", e);
        }
        catch (InvocationTargetException e) {
            throw new MessageDeliverException("Legacy composer class ('" + this._composerClass.getName() + "') process method '" + this._processMethod.getName() + "' failed with exception.", e.getCause());
        }
    }

    private void resolveComposerClass() throws ConfigurationException {
        Constructor constructor;
        String sProcessMethod = null;
        String sResponderMethod = null;
        String composerName = this.config.getRequiredAttribute("composer-class");
        try {
            this._composerClass = ClassUtil.forName(composerName, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Unable to locate composer class '" + composerName + "' on classpath.");
        }
        try {
            constructor = this._composerClass.getConstructor(ConfigTree.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Unable to construct legacy style composer class '" + composerName + "'.  Class must contain a constructor of the form '" + this._composerClass.getSimpleName() + "(ConfigTree)'");
        }
        try {
            this._composer = constructor.newInstance(this.config);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to construct legacy style composer class '" + composerName + "'.", e);
        }
        sProcessMethod = this.config.getAttribute("composer-process", "process");
        sResponderMethod = this.config.getAttribute("responder-process", "respond");
        try {
            this._processMethod = this._composerClass.getMethod(sProcessMethod, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Legacy style composer class '" + composerName + "' configuration is inavlid.  Class should contain a method called '" + sProcessMethod + "', with a single Object arg.");
        }
        try {
            this._responderMethod = this._composerClass.getMethod(sResponderMethod, this.getResponderParameters());
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Legacy style composer class '" + composerName + "' configuration is inavlid.  Class should contain a valid '" + sResponderMethod + "' method.");
        }
    }
}

