/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.tx;

import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.transport.InVMException;
import org.jboss.internal.soa.esb.couriers.transport.InVMTemporaryTransport;
import org.jboss.internal.soa.esb.couriers.transport.InVMTransport;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;

public class InVMXAResource
implements XAResource,
Serializable {
    public static final String INVM_RETRY_COUNT = "org.jboss.soa.esb.invm.retry.count";
    private static final long serialVersionUID = 77430212548543969L;
    private static int retryLimit;
    private static ServiceInvoker dlQueueInvoker;
    private transient InVMEpr inVMEpr;
    private transient Object msgObject;
    private transient Operation _opcode;
    private transient int _timeout;
    protected static final Logger _logger;

    public InVMXAResource(InVMEpr inVMEpr, Object msgObject, Operation op) {
        this.inVMEpr = inVMEpr;
        this.msgObject = msgObject;
        this._opcode = op;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this._opcode == Operation.INSERT) {
            boolean problem = false;
            try {
                this.deliverTx();
            }
            catch (Exception ex) {
                _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)ex);
                problem = true;
            }
            if (problem) {
                _logger.warn((Object)"InVMXAResource failed to commit to the InVM queue!");
                throw new XAException(8);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        if (this._opcode == Operation.REMOVE) {
            if (this.assertRedeliver()) {
                boolean problem = false;
                try {
                    this.deliverTx();
                }
                catch (Exception ex) {
                    _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)ex);
                    problem = true;
                }
                if (problem) {
                    _logger.warn((Object)"InVMXAResource could not rollback and put Message on to InVM queue!");
                    throw new XAException(8);
                }
            } else {
                try {
                    this.deliverToDLQ(this.getMessage());
                }
                catch (MessageDeliverException e) {
                    _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)e);
                    throw new XAException(8);
                }
            }
        }
    }

    protected void deliverTx() throws Exception {
        if (this.inVMEpr.isTemporaryEPR()) {
            InVMTemporaryTransport.getInstance().deliverTx(this.inVMEpr, this.msgObject);
        } else {
            InVMTransport.getInstance().deliverTx(this.inVMEpr, this.msgObject);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this._timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
    }

    private boolean assertRedeliver() throws XAException {
        Message message = this.getMessage();
        Integer retryCount = (Integer)message.getContext().getContext(INVM_RETRY_COUNT);
        if (retryCount == null || retryCount < retryLimit) {
            if (retryCount == null) {
                message.getContext().setContext(INVM_RETRY_COUNT, 1);
            } else {
                message.getContext().setContext(INVM_RETRY_COUNT, retryCount + 1);
            }
            try {
                this.msgObject = InVMTransport.toDeliveryObject(message, this.inVMEpr.getPassByValue());
            }
            catch (InVMException e) {
                _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)e);
                throw new XAException(8);
            }
            return true;
        }
        return false;
    }

    private Message getMessage() throws XAException {
        Message message;
        try {
            message = InVMTransport.fromDeliveryObject(this.msgObject, this.inVMEpr.getPassByValue());
        }
        catch (InVMException e) {
            _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)e);
            throw new XAException(8);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverToDLQ(Message message) throws MessageDeliverException {
        if (!"true".equalsIgnoreCase(Configuration.getRedeliveryDlsOn())) {
            _logger.debug((Object)"org.jboss.soa.esb.dls.redeliver is turned off");
        } else {
            Service service = ServiceInvoker.dlqService;
            synchronized (service) {
                if (dlQueueInvoker == null) {
                    dlQueueInvoker = new ServiceInvoker(ServiceInvoker.dlqService);
                }
            }
            dlQueueInvoker.deliverAsync(message);
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    static {
        String retryLimitConfig = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.invm.retry.limit", "5").trim();
        try {
            retryLimit = Integer.parseInt(retryLimitConfig);
        }
        catch (NumberFormatException e) {
            retryLimit = 5;
        }
        _logger = Logger.getLogger(InVMXAResource.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT,
        REMOVE;

    }
}

