/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.helpers.JDBCEprDBResourceFactory;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierServiceBindException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.Util;
import org.xml.sax.SAXException;

public class SqlTableCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    public static final String SQL_RETRY_COUNT = "org.jboss.soa.esb.sql.retry.count";
    protected long _pollLatency = 200L;
    protected long _sleepForRetries = 3000L;
    protected boolean deleteOnSuccess;
    protected boolean deleteOnError;
    protected boolean _isReceiver;
    private boolean monitoringRetryCount;
    private int messageType = 1111;
    private JDBCEprDBResourceFactory jdbcFactory;
    protected static final Logger _logger = Logger.getLogger(SqlTableCourier.class);
    private static ServiceInvoker dlQueueInvoker;
    private static int retryLimit;

    SqlTableCourier(JDBCEpr epr) throws CourierException {
        this(epr, false);
    }

    SqlTableCourier(JDBCEpr epr, boolean isReceiver) throws CourierException {
        this._isReceiver = isReceiver;
        this._sleepForRetries = 3000L;
        this.deleteOnSuccess = Boolean.TRUE.equals(Boolean.valueOf(epr.getPostDelete()));
        this.deleteOnError = Boolean.TRUE.equals(Boolean.valueOf(epr.getErrorDelete()));
        this.jdbcFactory = new JDBCEprDBResourceFactory(epr);
        this.monitoringRetryCount = epr.getRetryCountColumn() != null;
    }

    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deliver(Message message) throws CourierException {
        Serializable serializedMessage;
        String msgId;
        if (this._isReceiver) {
            throw new CourierException("This is a read-only Courier");
        }
        if (null == message) {
            return false;
        }
        Call call = message.getHeader().getCall();
        if (null == call) {
            call = new Call();
            message.getHeader().setCall(call);
        }
        try {
            if (null == call.getMessageID()) {
                call.setMessageID(new URI(UUID.randomUUID().toString()));
            }
            msgId = call.getMessageID().toString();
        }
        catch (URISyntaxException e) {
            throw new CourierException("Problems with message header ", e);
        }
        boolean transactional = this.isTransactional();
        try {
            serializedMessage = Util.serialize(message);
        }
        catch (Exception e) {
            throw new CourierTransportException("Unable to serialize ESB Message.", e);
        }
        Connection connection = this.jdbcFactory.createConnection(transactional);
        try {
            PreparedStatement insertStatement = this.jdbcFactory.createInsertStatement(connection);
            try {
                insertStatement.setString(1, msgId);
                int n = this.getMessageType(connection);
                switch (n) {
                    case 2004: {
                        byte[] blobData = serializedMessage.toString().getBytes();
                        ByteArrayInputStream bais = new ByteArrayInputStream(blobData);
                        insertStatement.setBinaryStream(2, (InputStream)bais, blobData.length);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] data = serializedMessage.toString().getBytes();
                        insertStatement.setBytes(2, data);
                        break;
                    }
                    case 2005: {
                        String clobData = serializedMessage.toString();
                        StringReader clobReader = new StringReader(clobData);
                        insertStatement.setCharacterStream(2, (Reader)clobReader, clobData.length());
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        insertStatement.setString(2, serializedMessage.toString());
                        break;
                    }
                    default: {
                        insertStatement.setObject(2, serializedMessage);
                    }
                }
                insertStatement.setString(3, State.Pending.getColumnValue());
                insertStatement.setLong(4, System.currentTimeMillis());
                insertStatement.executeUpdate();
            }
            finally {
                insertStatement.close();
            }
            if (!transactional) {
                connection.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            try {
                if (!transactional) {
                    connection.rollback();
                }
            }
            catch (Exception exception) {
                _logger.debug((Object)exception);
            }
            _logger.debug((Object)"SQL exception during deliver", (Throwable)e);
            throw new CourierTransportException(e);
        }
        finally {
            try {
                if (!transactional) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                _logger.error((Object)"Exception while closing DataSource connection.", (Throwable)e);
            }
        }
    }

    public Message pickup(long millis) throws CourierException, CourierTimeoutException {
        Message result = null;
        long limit = System.currentTimeMillis() + (millis < 100L ? 100L : millis);
        do {
            MessagePickupProspect pickupProspect;
            boolean transactional = this.isTransactional();
            try {
                pickupProspect = this.getPickupProspect(transactional);
            }
            catch (Exception e) {
                _logger.warn((Object)"Exception while attempting to lookup message pickup prospect.", (Throwable)e);
                return null;
            }
            if (pickupProspect == null) continue;
            Connection connection = this.jdbcFactory.createConnection(transactional);
            try {
                result = this.tryToPickup(pickupProspect, connection);
                if (!transactional) {
                    connection.commit();
                }
                if (result != null) {
                    if (transactional && this.monitoringRetryCount && pickupProspect.sendToDQL) {
                        this.deliverToDLQ(result);
                        Message message = null;
                        return message;
                    }
                    Message message = result;
                    return message;
                }
            }
            catch (FaultMessageException e) {
                throw e;
            }
            catch (Exception e) {
                _logger.warn((Object)"Exception during pickup", (Throwable)e);
                if (!transactional) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException e1) {
                        _logger.warn((Object)"SQL Exception during rollback", (Throwable)e);
                    }
                }
                throw new CourierTransportException(e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    _logger.warn((Object)"Error closing DataSource Connection.", (Throwable)e);
                }
            }
            try {
                long lSleep = limit - System.currentTimeMillis();
                if (this._pollLatency < lSleep) {
                    lSleep = this._pollLatency;
                }
                if (lSleep <= 0L) continue;
                Thread.sleep(lSleep);
            }
            catch (InterruptedException e) {
                return null;
            }
        } while (System.currentTimeMillis() <= limit);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessagePickupProspect getPickupProspect(boolean transactional) throws TransactionStrategyException, CourierServiceBindException, SQLException, CourierTransportException {
        MessagePickupProspect prospect = null;
        Connection connection = this.jdbcFactory.createConnection(transactional);
        try {
            PreparedStatement listStatement = this.jdbcFactory.createListStatement(connection);
            try {
                ResultSet resultSet = listStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        prospect = new MessagePickupProspect();
                        prospect.messageId = resultSet.getString(1);
                        prospect.timestamp = resultSet.getLong(2);
                        prospect.status = resultSet.getString(3);
                        if (transactional && this.monitoringRetryCount) {
                            prospect.retryCount = resultSet.getInt(4);
                        }
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                listStatement.close();
            }
        }
        finally {
            connection.close();
        }
        if (prospect != null && transactional && this.monitoringRetryCount) {
            if (prospect.retryCount >= retryLimit) {
                prospect.sendToDQL = true;
            }
            prospect = this.updateRetryCount(prospect);
        }
        return prospect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message tryToPickup(MessagePickupProspect prospect, Connection connection) throws CourierException, SQLException {
        block36: {
            PreparedStatement selectPicukupMessageStatement = this.jdbcFactory.createSelectPickupMessage(connection);
            try {
                selectPicukupMessageStatement.setString(1, prospect.messageId);
                selectPicukupMessageStatement.setString(2, prospect.status);
                selectPicukupMessageStatement.setLong(3, prospect.timestamp);
                ResultSet resultSet = selectPicukupMessageStatement.executeQuery();
                try {
                    if (!resultSet.next()) break block36;
                    Message result = null;
                    try {
                        Object value;
                        int type = this.getMessageType(resultSet);
                        switch (type) {
                            case 2004: {
                                byte[] blobData;
                                Blob blob = resultSet.getBlob(1);
                                byte[] byArray = blobData = blob != null ? StreamUtils.readStream(blob.getBinaryStream()) : null;
                                if (blobData != null) {
                                    value = new String(blobData);
                                    break;
                                }
                                value = "";
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                byte[] binaryData = StreamUtils.readStream(resultSet.getBinaryStream(1));
                                value = new String(binaryData);
                                break;
                            }
                            case 2005: {
                                Clob clob = resultSet.getClob(1);
                                if (clob != null) {
                                    value = StreamUtils.readReader(clob.getCharacterStream());
                                    break;
                                }
                                value = "";
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                value = resultSet.getString(1);
                                break;
                            }
                            default: {
                                value = (Serializable)resultSet.getObject(1);
                            }
                        }
                        result = Util.deserialize((Serializable)value);
                    }
                    catch (IOException e) {
                    }
                    catch (SAXException e) {
                    }
                    catch (ParserConfigurationException e) {
                    }
                    finally {
                        if (result == null && this.deleteOnError) {
                            this.deleteMsg(prospect.messageId, connection);
                        } else if (result != null && this.deleteOnSuccess) {
                            this.deleteMsg(prospect.messageId, connection);
                        } else if (result == null) {
                            this.changeStatus(prospect.messageId, State.Error, connection);
                        } else {
                            this.changeStatus(prospect.messageId, State.Done, connection);
                        }
                    }
                    Message message = result;
                    return message;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception ex) {
                        _logger.warn((Object)"Could not close ResultSet.", (Throwable)ex);
                    }
                }
            }
            finally {
                selectPicukupMessageStatement.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessagePickupProspect updateRetryCount(MessagePickupProspect prospect) throws SQLException, CourierServiceBindException, CourierTransportException, TransactionStrategyException {
        TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
        Object suspendedTX = txStrategy.suspend();
        try {
            txStrategy.begin();
            try {
                Connection connection = this.jdbcFactory.createConnection(true);
                boolean updated = false;
                try {
                    PreparedStatement updateStatement = this.jdbcFactory.createUpdateRetryCountStatement(connection);
                    try {
                        long readTimestamp = prospect.timestamp;
                        long updateTimeout = System.currentTimeMillis();
                        if (prospect.sendToDQL) {
                            prospect.status = State.Error.getColumnValue();
                        }
                        updateStatement.setInt(1, prospect.retryCount + 1);
                        updateStatement.setString(2, prospect.status);
                        updateStatement.setLong(3, updateTimeout);
                        updateStatement.setString(4, prospect.messageId);
                        updateStatement.setLong(5, readTimestamp);
                        prospect.timestamp = updateTimeout;
                        updated = updateStatement.executeUpdate() == 1;
                    }
                    finally {
                        updateStatement.close();
                    }
                }
                finally {
                    connection.close();
                }
                txStrategy.terminate();
                if (updated) {
                    MessagePickupProspect messagePickupProspect = prospect;
                    return messagePickupProspect;
                }
            }
            catch (Exception e) {
                txStrategy.rollbackOnly();
                txStrategy.terminate();
                _logger.debug((Object)("Error updating message retry count: " + e.getMessage()));
            }
        }
        finally {
            txStrategy.resume(suspendedTX);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMsg(String messageId, Connection connection) throws SQLException {
        PreparedStatement statement = this.jdbcFactory.createDeleteStatement(connection);
        try {
            statement.setString(1, messageId);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStatus(String messageId, State to, Connection connection) throws SQLException {
        PreparedStatement statement = this.jdbcFactory.createUpdateStatusStatement(connection);
        try {
            statement.setString(1, to.getColumnValue());
            statement.setString(2, messageId);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
    }

    public void setPollLatency(Long millis) {
        if (millis <= 200L) {
            _logger.warn((Object)("Poll latency must be >= 200 milliseconds - Keeping old value of " + this._pollLatency));
        } else {
            this._pollLatency = millis;
        }
    }

    private boolean isTransactional() throws CourierException {
        boolean transactional;
        try {
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            Object txHandle = txStrategy == null ? null : txStrategy.getTransaction();
            boolean isActive = txStrategy == null ? false : txStrategy.isActive();
            boolean bl = transactional = txHandle != null;
            if (transactional && !isActive) {
                throw new CourierException("Associated transaction is no longer active!");
            }
        }
        catch (TransactionStrategyException ex) {
            throw new CourierException(ex);
        }
        return transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getMessageType(Connection connection) throws SQLException {
        if (this.messageType != 1111) {
            return this.messageType;
        }
        PreparedStatement ps = this.jdbcFactory.createSelect4UpdateStatement(connection);
        try {
            int n;
            ps.setString(1, "");
            ps.setString(2, State.Pending.getColumnValue());
            ResultSet resultSet = ps.executeQuery();
            try {
                n = this.getMessageType(resultSet);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (Throwable th) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Throwable th) {
                // empty catch block
            }
            return n;
        }
        finally {
            try {
                ps.close();
            }
            catch (Throwable th) {}
        }
    }

    private synchronized int getMessageType(ResultSet resultSet) throws SQLException {
        if (this.messageType == 1111) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            this.messageType = metaData.getColumnType(1);
        }
        return this.messageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverToDLQ(Message message) throws MessageDeliverException {
        if (!"true".equalsIgnoreCase(Configuration.getRedeliveryDlsOn())) {
            _logger.debug((Object)"org.jboss.soa.esb.dls.redeliver is turned off");
        } else {
            if (dlQueueInvoker == null) {
                Service service = ServiceInvoker.dlqService;
                synchronized (service) {
                    if (dlQueueInvoker == null) {
                        dlQueueInvoker = new ServiceInvoker(ServiceInvoker.dlqService);
                    }
                }
            }
            dlQueueInvoker.deliverAsync(message);
        }
    }

    static {
        String retryLimitConfig = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.sql.retry.limit", "5").trim();
        try {
            retryLimit = Integer.parseInt(retryLimitConfig);
        }
        catch (NumberFormatException e) {
            retryLimit = 5;
        }
    }

    private class MessagePickupProspect {
        private String messageId;
        private String status;
        private long timestamp;
        public int retryCount;
        private boolean sendToDQL;

        private MessagePickupProspect() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Pending,
        WorkInProgress,
        Done,
        Error;


        public String getColumnValue() {
            return this.toString().substring(0, 1);
        }
    }
}

