/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.struts;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.springframework.samples.jpetstore.domain.Order;
import org.springframework.samples.jpetstore.web.struts.BaseActionForm;

public class OrderActionForm
extends BaseActionForm {
    private static final List CARD_TYPE_LIST = new ArrayList();
    private Order order = new Order();
    private boolean shippingAddressRequired = false;
    private boolean confirmed = false;
    private List cardTypeList = CARD_TYPE_LIST;

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public boolean isShippingAddressRequired() {
        return this.shippingAddressRequired;
    }

    public void setShippingAddressRequired(boolean shippingAddressRequired) {
        this.shippingAddressRequired = shippingAddressRequired;
    }

    public List getCreditCardTypes() {
        return this.cardTypeList;
    }

    public void doValidate(ActionMapping mapping, HttpServletRequest request, List errors) {
        if (!this.isShippingAddressRequired()) {
            this.addErrorIfStringEmpty(errors, "FAKE (!) credit card number required.", this.order.getCreditCard());
            this.addErrorIfStringEmpty(errors, "Expiry date is required.", this.order.getExpiryDate());
            this.addErrorIfStringEmpty(errors, "Card type is required.", this.order.getCardType());
            this.addErrorIfStringEmpty(errors, "Shipping Info: first name is required.", this.order.getShipToFirstName());
            this.addErrorIfStringEmpty(errors, "Shipping Info: last name is required.", this.order.getShipToLastName());
            this.addErrorIfStringEmpty(errors, "Shipping Info: address is required.", this.order.getShipAddress1());
            this.addErrorIfStringEmpty(errors, "Shipping Info: city is required.", this.order.getShipCity());
            this.addErrorIfStringEmpty(errors, "Shipping Info: state is required.", this.order.getShipState());
            this.addErrorIfStringEmpty(errors, "Shipping Info: zip/postal code is required.", this.order.getShipZip());
            this.addErrorIfStringEmpty(errors, "Shipping Info: country is required.", this.order.getShipCountry());
            this.addErrorIfStringEmpty(errors, "Billing Info: first name is required.", this.order.getBillToFirstName());
            this.addErrorIfStringEmpty(errors, "Billing Info: last name is required.", this.order.getBillToLastName());
            this.addErrorIfStringEmpty(errors, "Billing Info: address is required.", this.order.getBillAddress1());
            this.addErrorIfStringEmpty(errors, "Billing Info: city is required.", this.order.getBillCity());
            this.addErrorIfStringEmpty(errors, "Billing Info: state is required.", this.order.getBillState());
            this.addErrorIfStringEmpty(errors, "Billing Info: zip/postal code is required.", this.order.getBillZip());
            this.addErrorIfStringEmpty(errors, "Billing Info: country is required.", this.order.getBillCountry());
        }
        if (errors.size() > 0) {
            this.order.setBillAddress1(this.order.getShipAddress1());
            this.order.setBillAddress2(this.order.getShipAddress2());
            this.order.setBillToFirstName(this.order.getShipToFirstName());
            this.order.setBillToLastName(this.order.getShipToLastName());
            this.order.setBillCity(this.order.getShipCity());
            this.order.setBillCountry(this.order.getShipCountry());
            this.order.setBillState(this.order.getShipState());
            this.order.setBillZip(this.order.getShipZip());
        }
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.shippingAddressRequired = false;
    }

    static {
        CARD_TYPE_LIST.add("Visa");
        CARD_TYPE_LIST.add("MasterCard");
        CARD_TYPE_LIST.add("American Express");
    }
}

