/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import net.sourceforge.wife.swift.model.SwiftBlock2;
import org.apache.commons.lang.Validate;

public class SwiftBlock2Input
extends SwiftBlock2
implements Serializable {
    private String receiverAddress;
    private String deliveryMonitoring;
    private String obsolescencePeriod;

    public SwiftBlock2Input(String messageType, String receiverAddress, String messagePriority, String deliveryMonitoring, String obsolescencePeriod) {
        this.messageType = messageType;
        this.receiverAddress = receiverAddress;
        this.messagePriority = messagePriority;
        this.deliveryMonitoring = deliveryMonitoring;
        this.obsolescencePeriod = obsolescencePeriod;
    }

    public SwiftBlock2Input(String value) {
        this.setValue(value);
    }

    public SwiftBlock2Input() {
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public String getReceiverAddress() {
        return this.receiverAddress;
    }

    public void setMessagePriority(String messagePriority) {
        this.messagePriority = messagePriority;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public void setDeliveryMonitoring(String deliveryMonitoring) {
        this.deliveryMonitoring = deliveryMonitoring;
    }

    public String getDeliveryMonitoring() {
        return this.deliveryMonitoring;
    }

    public void setObsolescencePeriod(String obsolescencePeriod) {
        this.obsolescencePeriod = obsolescencePeriod;
    }

    public String getObsolescencePeriod() {
        return this.obsolescencePeriod;
    }

    public boolean isEmpty() {
        return this.messageType == null && this.receiverAddress == null && this.messagePriority == null && this.deliveryMonitoring == null && this.obsolescencePeriod == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuffer v = new StringBuffer("I");
        if (this.messageType != null) {
            v.append(this.messageType);
        }
        if (this.receiverAddress != null) {
            v.append(this.receiverAddress);
        }
        if (this.messagePriority != null) {
            v.append(this.messagePriority);
        }
        if (this.deliveryMonitoring != null) {
            v.append(this.deliveryMonitoring);
        }
        if (this.obsolescencePeriod != null) {
            v.append(this.obsolescencePeriod);
        }
        return v.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String value) {
        int slen = value.length();
        Validate.notNull((Object)value, (String)"value must not be null");
        Validate.isTrue((slen >= 16 && slen <= 23 ? 1 : 0) != 0, (String)("expected a string value of 17 up to 23 chars and obtained a " + slen + " chars string: '" + value + "'"));
        int offset = 0;
        if (value.startsWith("2:I")) {
            offset = 2;
        }
        if ((slen -= offset) != 16 && slen != 17 && slen != 18 && slen != 21) {
            throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
        }
        if (Character.toUpperCase(value.charAt(offset)) != 'I') {
            throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
        }
        int len = 3;
        this.setMessageType(this.getValuePart(value, ++offset, len));
        offset += len;
        len = 12;
        this.setReceiverAddress(this.getValuePart(value, offset, len));
        offset += len;
        len = 1;
        this.setMessagePriority(this.getValuePart(value, offset, len));
        offset += len;
        len = 1;
        this.setDeliveryMonitoring(this.getValuePart(value, offset, len));
        offset += len;
        len = 3;
        this.setObsolescencePeriod(this.getValuePart(value, offset, len));
        offset += len;
    }

    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public boolean isInput() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.deliveryMonitoring == null ? 0 : this.deliveryMonitoring.hashCode());
        result = 31 * result + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        result = 31 * result + (this.obsolescencePeriod == null ? 0 : this.obsolescencePeriod.hashCode());
        result = 31 * result + (this.receiverAddress == null ? 0 : this.receiverAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlock2Input other = (SwiftBlock2Input)obj;
        if (this.deliveryMonitoring == null ? other.deliveryMonitoring != null : !this.deliveryMonitoring.equals(other.deliveryMonitoring)) {
            return false;
        }
        if (this.messagePriority == null ? other.messagePriority != null : !this.messagePriority.equals(other.messagePriority)) {
            return false;
        }
        if (this.messageType == null ? other.messageType != null : !this.messageType.equals(other.messageType)) {
            return false;
        }
        if (this.obsolescencePeriod == null ? other.obsolescencePeriod != null : !this.obsolescencePeriod.equals(other.obsolescencePeriod)) {
            return false;
        }
        return !(this.receiverAddress == null ? other.receiverAddress != null : !this.receiverAddress.equals(other.receiverAddress));
    }
}

