/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.JSFDeployment;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.deployers.FacesConfigParsingUtil;

public class WebContextParamFacesConfigParsingDeployer
extends AbstractDeployer {
    private static Logger logger = Logger.getLogger(WebContextParamFacesConfigParsingDeployer.class);
    private static final String JAVAX_FACES_CONFIG_FILES_CONTEXT_PARAM_NAME = "javax.faces.CONFIG_FILES";
    private static final String WEB_INF_FACES_CONFIG_XML = "/WEB-INF/faces-config.xml";

    public WebContextParamFacesConfigParsingDeployer() {
        this.setInput(WebMetaData.class);
        this.setOutput(JSFDeployment.class);
        this.setStage(DeploymentStages.PARSE);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        if (webMetaData == null) {
            return;
        }
        List contextParams = webMetaData.getContextParams();
        if (contextParams == null || contextParams.isEmpty()) {
            return;
        }
        JSFDeployment jsfDeployment = (JSFDeployment)vfsDeploymentUnit.getAttachment(JSFDeployment.class);
        if (jsfDeployment == null) {
            jsfDeployment = new JSFDeployment();
            vfsDeploymentUnit.addAttachment(JSFDeployment.class, (Object)jsfDeployment);
        }
        for (ParamValueMetaData contextParam : contextParams) {
            if (contextParam == null || !JAVAX_FACES_CONFIG_FILES_CONTEXT_PARAM_NAME.equals(contextParam.getParamName())) continue;
            try {
                logger.debug((Object)("Found javax.faces.CONFIG_FILES param with values: " + contextParam.getParamValue() + " in unit " + vfsDeploymentUnit));
                this.processConfigFilesContextParamValue(vfsDeploymentUnit, jsfDeployment, contextParam.getParamValue());
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    private void processConfigFilesContextParamValue(VFSDeploymentUnit vfsDeploymentUnit, JSFDeployment jsfDeployment, String configFilesContextParamValue) throws Exception {
        String[] paths;
        if (configFilesContextParamValue == null) {
            return;
        }
        String trimmedConfigParamValues = configFilesContextParamValue.trim();
        for (String path : paths = trimmedConfigParamValues.split(",")) {
            if ((path = path.trim()).isEmpty() || WEB_INF_FACES_CONFIG_XML.equals(path)) continue;
            VirtualFile facesConfigXml = vfsDeploymentUnit.getRoot().getChild(path);
            if (facesConfigXml == null) {
                logger.warn((Object)("Faces config xml not found at relative path: " + path + " in unit " + vfsDeploymentUnit.getRoot()));
                continue;
            }
            logger.debug((Object)("Found faces config xml with relative path: " + path + " in unit " + vfsDeploymentUnit.getRoot()));
            FacesConfigParsingUtil.parse((DeploymentUnit)vfsDeploymentUnit, facesConfigXml.toURL(), jsfDeployment);
        }
    }
}

