/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.spring.deployers.SpringMetaData;
import org.jboss.spring.factory.Nameable;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringMetaDataDeployer<T extends BeanFactory>
extends AbstractRealDeployerWithInput<SpringMetaData> {
    protected AbstractSpringMetaDataDeployer() {
        this.setDeploymentVisitor(this.createDeploymentVisitor());
    }

    protected abstract DeploymentVisitor<SpringMetaData> createDeploymentVisitor();

    protected void bind(T beanFactory, String name) throws DeploymentException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            NonSerializableFactory.rebind((Context)ctx, (String)name, beanFactory);
        }
        catch (NamingException e) {
            throw new DeploymentException("Unable to bind BeanFactory into JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            ctx.unbind(name);
            NonSerializableFactory.unbind((String)name);
        }
        catch (NamingException e) {
            this.log.warn((Object)"Unable to unbind BeanFactory from JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected T lookup(String name) throws Exception {
        Class<T> beanFactoryClass = this.getExactBeanFactoryClass();
        BeanFactory beanFactory = (BeanFactory)beanFactoryClass.cast(Util.lookup((String)name, beanFactoryClass));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Found Spring bean factory [" + name + "]: " + beanFactory));
        }
        return (T)beanFactory;
    }

    protected abstract Class<T> getExactBeanFactoryClass();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class SpringDeploymentVisitor
    implements DeploymentVisitor<SpringMetaData> {
        protected SpringDeploymentVisitor() {
        }

        public Class<SpringMetaData> getVisitorType() {
            return SpringMetaData.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deploy(DeploymentUnit unit, SpringMetaData springMetaData) throws DeploymentException {
            ClassLoader classLoader = unit.getClassLoader();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                Object beanFactory = this.doCreate(springMetaData);
                String name = ((Nameable)beanFactory).getName();
                springMetaData.setName(name);
                AbstractSpringMetaDataDeployer.this.bind(beanFactory, name);
                if (AbstractSpringMetaDataDeployer.this.log.isTraceEnabled()) {
                    AbstractSpringMetaDataDeployer.this.log.trace((Object)("Bean factory [" + name + "] binded to local JNDI."));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }

        protected abstract T doCreate(SpringMetaData var1);

        public void undeploy(DeploymentUnit unit, SpringMetaData springMetaData) {
            block4: {
                String name = springMetaData.getName();
                try {
                    Object beanFactory = AbstractSpringMetaDataDeployer.this.lookup(name);
                    if (beanFactory != null) {
                        this.doClose(beanFactory);
                        AbstractSpringMetaDataDeployer.this.unbind(name);
                        if (AbstractSpringMetaDataDeployer.this.log.isTraceEnabled()) {
                            AbstractSpringMetaDataDeployer.this.log.trace((Object)("Bean factory [" + name + "] unbinded from local JNDI."));
                        }
                    }
                }
                catch (Exception e) {
                    if (!AbstractSpringMetaDataDeployer.this.log.isTraceEnabled()) break block4;
                    AbstractSpringMetaDataDeployer.this.log.trace((Object)("Exception finding BeanFactory instance named " + name), (Throwable)e);
                }
            }
        }

        protected abstract void doClose(T var1);
    }
}

