/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.stack.cxf.ServletControllerExt;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.management.InstrumentationManagerExtImpl;

public class CXFServletExt
extends CXFServlet {
    public static final String ENABLE_CXF_MANAGEMENT = "enable.cxf.management";
    protected Endpoint endpoint;
    protected EndpointRegistry epRegistry;

    public ServletController createServletController(ServletConfig servletConfig) {
        ServletTransportFactory stf = (ServletTransportFactory)this.createServletTransportFactory();
        return new ServletControllerExt(stf, servletConfig, servletConfig.getServletContext(), this.bus);
    }

    public void loadBus(ServletConfig servletConfig) throws ServletException {
        this.initEndpoint(servletConfig);
        ServletContext svCtx = this.getServletContext();
        this.updateAvailableBusWithServletInfo(servletConfig);
        if (svCtx.getInitParameter(ENABLE_CXF_MANAGEMENT) != null && "true".equalsIgnoreCase(svCtx.getInitParameter(ENABLE_CXF_MANAGEMENT))) {
            this.registerInstrumentManger(this.bus);
        }
    }

    private void updateAvailableBusWithServletInfo(ServletConfig servletConfig) {
        BusHolder holder = (BusHolder)this.endpoint.getAttachment(BusHolder.class);
        this.bus = holder.getBus();
        BusFactory.possiblySetDefaultBus((Bus)this.bus);
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(servletConfig.getServletContext()));
        this.replaceDestinationFactory();
        this.controller = this.createServletController(servletConfig);
        servletConfig.getServletContext().setAttribute(ServletController.class.getName(), (Object)this.getController());
    }

    private void initEndpoint(ServletConfig servletConfig) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        ServletContext context = servletConfig.getServletContext();
        String contextPath = context.getContextPath();
        this.endpoint = this.initServiceEndpoint(contextPath);
    }

    protected void invoke(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            BusFactory.setThreadDefaultBus((Bus)this.getBus());
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
        finally {
            EndpointAssociation.removeEndpoint();
            BusFactory.setThreadDefaultBus(null);
        }
    }

    private Endpoint initServiceEndpoint(String contextPath) {
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        Endpoint endpoint = null;
        String servletName = this.getServletName();
        for (ObjectName sepId : this.epRegistry.getEndpoints()) {
            String propContext = sepId.getKeyProperty("context");
            String propEndpoint = sepId.getKeyProperty("endpoint");
            if (!servletName.equals(propEndpoint) || !contextPath.equals(propContext)) continue;
            endpoint = this.epRegistry.getEndpoint(sepId);
            break;
        }
        if (endpoint == null) {
            ObjectName oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName));
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
        return endpoint;
    }

    private void registerInstrumentManger(Bus bus) throws ServletException {
        InstrumentationManagerExtImpl instrumentationManagerImpl = new InstrumentationManagerExtImpl();
        instrumentationManagerImpl.setBus(bus);
        instrumentationManagerImpl.setEnabled(true);
        instrumentationManagerImpl.initMBeanServer();
        instrumentationManagerImpl.register();
        bus.setExtension((Object)instrumentationManagerImpl, InstrumentationManager.class);
        CounterRepository couterRepository = new CounterRepository();
        couterRepository.setBus(bus);
        try {
            Method method = CounterRepository.class.getDeclaredMethod("registerInterceptorsToBus", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)couterRepository, new Object[0]);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

