/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.gui.Logger;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import edu.umd.cs.findbugs.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 3546076956480385584L;
    static Pattern pattern = Pattern.compile("@VERSION@");
    private JEditorPane aboutEditorPane;
    private JScrollPane aboutScrollPane;
    private JTabbedPane aboutTabPane;
    private JEditorPane acknowldgementsEditorPane;
    private JScrollPane acknowledgmentsScrollPane;
    private JSeparator jSeparator1;
    private JEditorPane licenseEditorPane;
    private JScrollPane licenseScrollPane;
    private JButton okButton;

    public AboutDialog(JFrame parent, Logger l, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        try {
            this.aboutEditorPane.setPage(this.getClass().getClassLoader().getResource("edu/umd/cs/findbugs/gui/help/About.html"));
            this.licenseEditorPane.setPage(this.getClass().getClassLoader().getResource("edu/umd/cs/findbugs/gui/help/License.html"));
            this.acknowldgementsEditorPane.setPage(this.getClass().getClassLoader().getResource("edu/umd/cs/findbugs/gui/help/Acknowledgements.html"));
        }
        catch (IOException e) {
            l.logMessage(2, e.toString());
        }
        this.setTitle(MessageFormat.format(L10N.getLocalString("dlg.aboutfindbugs_ttl", "About FindBugs {0}"), Version.RELEASE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    private void processPage(JEditorPane pane, String fileName) throws IOException {
        InputStream in = null;
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder buf = new StringBuilder();
            in = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (in == null) {
                throw new IOException(MessageFormat.format(L10N.getLocalString("msg.couldntload_txt", "Couldn't load {0}"), fileName));
            }
            reader = new BufferedReader(Util.getReader(in));
            while ((line = reader.readLine()) != null) {
                line = pattern.matcher(line).replaceAll(Version.RELEASE);
                buf.append(line);
                buf.append('\n');
            }
            String text = buf.toString();
            pane.setContentType("text/html");
            pane.setText(text);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                } else if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void initComponents() {
        this.aboutTabPane = new JTabbedPane();
        this.aboutScrollPane = new JScrollPane();
        this.aboutEditorPane = new JEditorPane();
        this.licenseScrollPane = new JScrollPane();
        this.licenseEditorPane = new JEditorPane();
        this.acknowledgmentsScrollPane = new JScrollPane();
        this.acknowldgementsEditorPane = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.aboutEditorPane.setEditable(false);
        this.aboutEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.aboutScrollPane.setViewportView(this.aboutEditorPane);
        this.aboutTabPane.addTab("About", this.aboutScrollPane);
        this.licenseEditorPane.setEditable(false);
        this.licenseEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.licenseScrollPane.setViewportView(this.licenseEditorPane);
        this.aboutTabPane.addTab("License", this.licenseScrollPane);
        this.acknowldgementsEditorPane.setEditable(false);
        this.acknowldgementsEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.acknowledgmentsScrollPane.setViewportView(this.acknowldgementsEditorPane);
        this.aboutTabPane.addTab("Acknowledgments", this.acknowledgmentsScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.aboutTabPane, gridBagConstraints);
        this.aboutTabPane.setTitleAt(0, L10N.getLocalString("dlg.about_tab", "About"));
        this.aboutTabPane.setTitleAt(1, L10N.getLocalString("dlg.license_tab", "License"));
        this.aboutTabPane.setTitleAt(2, L10N.getLocalString("dlg.acknowledgements_tab", "Acknowledgements"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setText(L10N.getLocalString("dlg.ok_btn", "OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.pack();
    }

    private void editorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        try {
            if (evt.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                URL url = evt.getURL();
                LaunchBrowser.showDocument(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

