/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconditionalValueDerefDataflowFactory
extends AnalysisFactory<UnconditionalValueDerefDataflow> {
    public UnconditionalValueDerefDataflowFactory() {
        super("unconditional value dereference analysis", UnconditionalValueDerefDataflow.class);
    }

    @Override
    public UnconditionalValueDerefDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            throw new MethodUnprofitableException(descriptor);
        }
        CFG cfg = this.getCFG(analysisCache, descriptor);
        ValueNumberDataflow vnd = this.getValueNumberDataflow(analysisCache, descriptor);
        UnconditionalValueDerefAnalysis analysis = new UnconditionalValueDerefAnalysis(this.getReverseDepthFirstSearch(analysisCache, descriptor), this.getDepthFirstSearch(analysisCache, descriptor), cfg, this.getMethod(analysisCache, descriptor), methodGen, vnd, this.getAssertionMethods(analysisCache, descriptor.getClassDescriptor()));
        IsNullValueDataflow inv = this.getIsNullValueDataflow(analysisCache, descriptor);
        analysis.clearDerefsOnNonNullBranches(inv);
        TypeDataflow typeDataflow = this.getTypeDataflow(analysisCache, descriptor);
        analysis.setTypeDataflow(typeDataflow);
        UnconditionalValueDerefDataflow dataflow = new UnconditionalValueDerefDataflow(cfg, analysis);
        dataflow.execute();
        if (ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            dataflow.dumpDataflow(analysis);
        }
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            ClassContext.dumpDataflowInformation(this.getMethod(analysisCache, descriptor), cfg, vnd, inv, dataflow, typeDataflow);
        }
        return dataflow;
    }
}

