/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DirChooser
extends JDialog
implements TreeSelectionListener,
TreeWillExpandListener,
FileFilter {
    private static final long serialVersionUID = 7363990421558828943L;
    private static final FileSystemView FILE_VIEW = FileSystemView.getFileSystemView();
    private JTree tree;
    private JTextField dirText;
    private JScrollPane scrollPane;
    private JButton selectButton;
    private JButton cancelButton;
    private boolean showHidden = false;
    private String selectedDir = null;

    private DirChooser(Component comp, String title, File selDir) {
        super(JOptionPane.getFrameForComponent(comp), title, true);
        this.initComponents();
        this.selectDirectory(selDir);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        container.add((Component)tabPane, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        tabPane.add("Directory", topPanel);
        this.tree = new JTree();
        this.scrollPane = new JScrollPane(this.tree);
        topPanel.add((Component)this.scrollPane, "Center");
        JPanel dirTextPanel = new JPanel(new BorderLayout());
        dirTextPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.add((Component)dirTextPanel, "South");
        JLabel dirLab = new JLabel("Directory:  ");
        dirTextPanel.add((Component)dirLab, "West");
        this.dirText = new JTextField();
        dirTextPanel.add((Component)this.dirText, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        container.add((Component)bottomPanel, "South");
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirChooser.this.selectedDir = DirChooser.this.dirText.getText();
                DirChooser.this.dispose();
            }
        });
        bottomPanel.add(this.selectButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirChooser.this.selectedDir = null;
                DirChooser.this.dispose();
            }
        });
        bottomPanel.add(this.cancelButton);
        this.populateTree();
        this.setSize(300, 300);
    }

    private void populateTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("My Computer");
        DefaultTreeModel model = new DefaultTreeModel(rootNode, true);
        File[] rootDrives = File.listRoots();
        DefaultMutableTreeNode[] driveNodes = new DefaultMutableTreeNode[rootDrives.length];
        for (int i = 0; i < rootDrives.length; ++i) {
            driveNodes[i] = new DefaultMutableTreeNode(rootDrives[i]);
            rootNode.add(driveNodes[i]);
        }
        this.tree.setModel(model);
        this.tree.setRootVisible(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeWillExpandListener(this);
        this.tree.setCellRenderer(new DirTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
    }

    public void selectDirectory(File dir) {
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            return;
        }
        try {
            dir = dir.getCanonicalFile();
        }
        catch (Exception ex) {
            return;
        }
        if (!dir.isDirectory() && (dir = dir.getParentFile()) == null) {
            return;
        }
        ArrayList<File> dirs = new ArrayList<File>();
        while (true) {
            File parent;
            dirs.add(dir);
            if (FILE_VIEW.isRoot(dir) || (parent = dir.getParentFile()) == null) break;
            if (!parent.exists()) {
                return;
            }
            dir = parent;
        }
        JViewport viewPort = this.scrollPane.getViewport();
        TreeModel model = this.tree.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        int i = dirs.size();
        while (--i >= 0) {
            int j;
            File currDir = (File)dirs.get(i);
            this.tree.expandPath(new TreePath(node.getPath()));
            int count = node.getChildCount();
            for (j = 0; j < count; ++j) {
                DefaultMutableTreeNode currNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (!currNode.getUserObject().equals(currDir)) continue;
                node = currNode;
                TreePath currPath = new TreePath(currNode.getPath());
                this.tree.setSelectionPath(currPath);
                Rectangle rect = this.tree.getPathBounds(currPath);
                if (rect == null) break;
                viewPort.setViewPosition(rect.getLocation());
                break;
            }
            if (j != count) continue;
            break;
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        int id = e.getID();
        if (id == 201) {
            this.selectedDir = null;
            this.dispose();
        } else {
            super.processWindowEvent(e);
        }
    }

    public static String showDialog(Component parent, String title, File initFile) {
        DirChooser chooser = new DirChooser(parent, title, initFile);
        chooser.setLocationRelativeTo(parent);
        chooser.setVisible(true);
        return chooser.selectedDir;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            File dir = (File)node.getUserObject();
            this.dirText.setText(dir.getAbsolutePath());
        }
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void treeWillExpand(TreeExpansionEvent e) {
        Object[] childDirs;
        TreePath path = e.getPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        File selDir = (File)node.getUserObject();
        if (node.getChildCount() > 0) {
            node.removeAllChildren();
        }
        if ((childDirs = selDir.listFiles(this)) == null) {
            return;
        }
        Arrays.sort(childDirs);
        for (int i = 0; i < childDirs.length; ++i) {
            if (((File)childDirs[i]).isHidden()) {
                if (!this.showHidden) continue;
                node.add(new DefaultMutableTreeNode(childDirs[i]));
                continue;
            }
            node.add(new DefaultMutableTreeNode(childDirs[i]));
        }
    }

    public boolean accept(File pathname) {
        return pathname.isDirectory();
    }

    static class DirTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -200713666464104466L;

        DirTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            File dir = (File)node.getUserObject();
            String name = dir.getName().trim();
            if (name == null || name.equals("")) {
                name = dir.getAbsolutePath();
            }
            return super.getTreeCellRendererComponent(tree, name, selected, expanded, leaf, row, hasFocus);
        }
    }
}

