/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.NamespaceTable;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormComboBox;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormTextField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import com.eviware.x.impl.swing.FileFormField;
import com.eviware.x.impl.swing.JCheckBoxFormField;
import com.eviware.x.impl.swing.JComboBoxFormField;
import com.eviware.x.impl.swing.JLabelFormField;
import com.eviware.x.impl.swing.JPasswordFieldFormField;
import com.eviware.x.impl.swing.JTextAreaFormField;
import com.eviware.x.impl.swing.JTextFieldFormField;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingXFormImpl
implements XForm {
    private JPanel panel;
    private CellConstraints cc = new CellConstraints();
    private FormLayout layout;
    private RowSpec rowSpec;
    private int rowSpacing = 5;
    private Map<String, XFormField> components = new HashMap<String, XFormField>();
    private String rowAlignment = "top";
    private String name;

    public SwingXFormImpl(String name) {
        this.name = name;
        this.layout = new FormLayout("5px,right:pref,5px,left:default,5px:grow(1.0)");
        this.panel = new JPanel((LayoutManager)this.layout);
        this.rowSpec = new RowSpec(this.rowAlignment + ":pref");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void addSpace(int size) {
        if (size > 0) {
            this.layout.appendRow(new RowSpec(size + "px"));
        }
    }

    @Override
    public XFormField addCheckBox(String name, String description) {
        JCheckBoxFormField checkBox = new JCheckBoxFormField(description == null ? name : description);
        this.addComponent(name, checkBox);
        return checkBox;
    }

    @Override
    public XFormField addComponent(String label, XFormField formComponent) {
        this.components.put(label, formComponent);
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        AbstractSwingXFormField swingFormComponent = (AbstractSwingXFormField)formComponent;
        if (label != null) {
            JLabel jlabel = new JLabel(label);
            jlabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.panel.add((Component)jlabel, this.cc.xy(2, row));
        }
        this.panel.add((Component)swingFormComponent.getComponent(), this.cc.xy(4, row));
        this.components.put(label, formComponent);
        return formComponent;
    }

    @Override
    public XFormComboBox addComboBox(String name, Object[] values, String description) {
        JComboBoxFormField comboBox = new JComboBoxFormField(values);
        comboBox.setToolTip(description);
        this.addComponent(name, comboBox);
        return comboBox;
    }

    @Override
    public <T> XFormComboBox addComboBox(String name, Object[] values, String description, T target, SoapUIAction<T> action) {
        return null;
    }

    @Override
    public void addSeparator() {
        this.addSeparator(null);
    }

    @Override
    public void addSeparator(String label) {
        this.addSpace(this.rowSpacing);
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        if (label == null) {
            this.panel.add((Component)new JSeparator(), this.cc.xywh(2, row, 3, 1));
        } else {
            this.panel.add((Component)new JLabel(label), this.cc.xywh(2, row, 3, 1));
        }
    }

    @Override
    public XFormTextField addTextField(String name, String description, XForm.FieldType type) {
        if (type == XForm.FieldType.FOLDER || type == XForm.FieldType.FILE || type == XForm.FieldType.PROJECT_FOLDER || type == XForm.FieldType.PROJECT_FILE) {
            return (XFormTextField)this.addComponent(name, new FileFormField(description, type));
        }
        if (type == XForm.FieldType.PASSWORD) {
            JPasswordFieldFormField pwdField = new JPasswordFieldFormField();
            ((JPasswordField)pwdField.getComponent()).setColumns(30);
            pwdField.setToolTip(description);
            this.addComponent(name, pwdField);
            return pwdField;
        }
        if (type == XForm.FieldType.TEXTAREA) {
            JTextAreaFormField field = new JTextAreaFormField();
            field.getTextArea().setColumns(40);
            field.getTextArea().setRows(5);
            field.setToolTip(description);
            this.addComponent(name, field);
            return field;
        }
        JTextFieldFormField textField = new JTextFieldFormField();
        ((JTextField)textField.getComponent()).setColumns(40);
        textField.setToolTip(description);
        this.addComponent(name, textField);
        return textField;
    }

    public void setComponentValue(String label, String value) {
        XFormField component = this.getComponent(label);
        if (component != null) {
            component.setValue(value);
        }
    }

    @Override
    public String getComponentValue(String name) {
        XFormField component = this.getComponent(name);
        return component == null ? null : component.getValue();
    }

    @Override
    public XFormField getComponent(String label) {
        return this.components.get(label);
    }

    public void setBorder(Border border) {
        this.panel.setBorder(border);
    }

    public XFormField addComponent(XFormField component) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        AbstractSwingXFormField swingFormComponent = (AbstractSwingXFormField)component;
        this.panel.add((Component)swingFormComponent.getComponent(), this.cc.xyw(1, row, 4));
        return component;
    }

    @Override
    public void setValues(StringToStringMap values) {
        for (String key : values.keySet()) {
            this.setComponentValue(key, (String)values.get(key));
        }
    }

    @Override
    public StringToStringMap getValues() {
        StringToStringMap values = new StringToStringMap();
        for (String key : this.components.keySet()) {
            values.put(key, this.getComponentValue(key));
        }
        return values;
    }

    @Override
    public void addNameSpaceTable(String label, Interface modelItem) {
        this.addComponent(label, new NamespaceTable(modelItem));
    }

    @Override
    public void setOptions(String name, Object[] values) {
        JComboBoxFormField combo = (JComboBoxFormField)this.getComponent(name);
        if (combo != null) {
            combo.setOptions(values);
        }
    }

    @Override
    public void addLabel(String name, String label) {
        this.addComponent(name, new JLabelFormField(label));
    }

    @Override
    public XFormField[] getFormFields() {
        return this.components.values().toArray(new XFormField[this.components.size()]);
    }

    @Override
    public void setFormFieldProperty(String name, Object value) {
        for (XFormField field : this.components.values()) {
            field.setProperty(name, value);
        }
    }

    @Override
    public String[] getOptions(String name) {
        XFormField combo = this.getComponent(name);
        if (combo instanceof JComboBoxFormField) {
            return ((JComboBoxFormField)combo).getOptions();
        }
        return null;
    }

    @Override
    public XFormField getFormField(String name) {
        return this.components.get(name);
    }
}

