/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.components.Undoable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public final class JTextComponentPopupMenu
extends JPopupMenu
implements PopupMenuListener {
    private final JTextComponent textComponent;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private ClearAction clearAction;
    private SelectAllAction selectAllAction;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static JTextComponentPopupMenu add(JTextComponent textComponent) {
        JTextComponentPopupMenu popupMenu = new JTextComponentPopupMenu(textComponent);
        textComponent.setComponentPopupMenu(popupMenu);
        return popupMenu;
    }

    private JTextComponentPopupMenu(JTextComponent textComponent) {
        super("Edit");
        this.textComponent = textComponent;
        if (textComponent instanceof Undoable) {
            this.undoAction = new UndoAction();
            this.add(this.undoAction);
            this.redoAction = new RedoAction();
            this.add(this.redoAction);
            this.addSeparator();
        }
        this.cutAction = new CutAction();
        this.add(this.cutAction);
        this.copyAction = new CopyAction();
        this.add(this.copyAction);
        this.pasteAction = new PasteAction();
        this.add(this.pasteAction);
        this.clearAction = new ClearAction();
        this.add(this.clearAction);
        this.addSeparator();
        this.selectAllAction = new SelectAllAction();
        this.add(this.selectAllAction);
        this.addPopupMenuListener(this);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.textComponent instanceof Undoable) {
            this.undoAction.setEnabled(((Undoable)((Object)this.textComponent)).canUndo());
            this.redoAction.setEnabled(((Undoable)((Object)this.textComponent)).canRedo());
        }
        this.cutAction.setEnabled(this.textComponent.getSelectionEnd() != this.textComponent.getSelectionStart());
        this.copyAction.setEnabled(this.cutAction.isEnabled());
        this.clearAction.setEnabled(this.cutAction.isEnabled());
        this.selectAllAction.setEnabled(this.cutAction.isEnabled());
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
        }

        public void actionPerformed(ActionEvent e) {
            ((Undoable)((Object)JTextComponentPopupMenu.this.textComponent)).redo();
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
        }

        public void actionPerformed(ActionEvent e) {
            ((Undoable)((Object)JTextComponentPopupMenu.this.textComponent)).undo();
        }
    }

    private final class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select All");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.selectAll();
        }
    }

    private final class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.setText("");
        }
    }

    private final class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.paste();
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.copy();
        }
    }

    private final class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.cut();
        }
    }
}

