/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.MockOperationTreeNode;
import com.eviware.soapui.settings.UISettings;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServiceTreeNode
extends AbstractModelItemTreeNode<MockService> {
    private AbstractModelItemTreeNode.ReorderPropertyChangeListener propertyChangeListener = new AbstractModelItemTreeNode.ReorderPropertyChangeListener();
    private List<MockOperationTreeNode> mockOperationNodes = new ArrayList<MockOperationTreeNode>();
    private InternalMockServiceListener mockServiceListener = new InternalMockServiceListener();

    public MockServiceTreeNode(MockService mockService, SoapUITreeModel treeModel) {
        super(mockService, mockService.getProject(), treeModel);
        mockService.addMockServiceListener(this.mockServiceListener);
        for (int c = 0; c < mockService.getMockOperationCount(); ++c) {
            MockOperation mockOperation = mockService.getMockOperationAt(c);
            mockOperation.addPropertyChangeListener(MockService.NAME_PROPERTY, this.propertyChangeListener);
            this.mockOperationNodes.add(new MockOperationTreeNode(mockOperation, this.getTreeModel()));
        }
        this.initOrdering(this.mockOperationNodes, UISettings.ORDER_MOCKOPERATION);
        this.getTreeModel().mapModelItems(this.mockOperationNodes);
    }

    @Override
    public void release() {
        super.release();
        ((MockService)this.getModelItem()).removeMockServiceListener(this.mockServiceListener);
        for (MockOperationTreeNode treeNode : this.mockOperationNodes) {
            treeNode.release();
        }
    }

    public MockService getMockService() {
        return (MockService)this.getModelItem();
    }

    @Override
    public int getChildCount() {
        return this.mockOperationNodes.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.mockOperationNodes.indexOf(child);
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.mockOperationNodes.get(index);
    }

    private final class InternalMockServiceListener
    implements MockServiceListener {
        private InternalMockServiceListener() {
        }

        public void mockOperationAdded(MockOperation mockOperation) {
            MockOperationTreeNode mockOperationTreeNode = new MockOperationTreeNode(mockOperation, MockServiceTreeNode.this.getTreeModel());
            MockServiceTreeNode.this.mockOperationNodes.add(mockOperationTreeNode);
            MockServiceTreeNode.this.getTreeModel().notifyNodeInserted(mockOperationTreeNode);
        }

        public void mockOperationRemoved(MockOperation mockOperation) {
            SoapUITreeNode treeNode = MockServiceTreeNode.this.getTreeModel().getTreeNode(mockOperation);
            if (!MockServiceTreeNode.this.mockOperationNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown mockOperation");
            }
            MockServiceTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            MockServiceTreeNode.this.mockOperationNodes.remove(treeNode);
        }

        public void mockResponseAdded(MockResponse mockResponse) {
            MockOperationTreeNode operationTreeNode = (MockOperationTreeNode)MockServiceTreeNode.this.getTreeModel().getTreeNode(mockResponse.getMockOperation());
            if (operationTreeNode == null) {
                throw new RuntimeException("Adding mockResponse to unknwown MockOperation");
            }
            operationTreeNode.mockResponseAdded(mockResponse);
        }

        public void mockResponseRemoved(MockResponse mockResponse) {
            MockOperationTreeNode operationTreeNode = (MockOperationTreeNode)MockServiceTreeNode.this.getTreeModel().getTreeNode(mockResponse.getMockOperation());
            if (operationTreeNode == null) {
                throw new RuntimeException("Removing mockResponse from unknown MockOperation");
            }
            operationTreeNode.mockResponseRemoved(mockResponse);
        }
    }
}

