/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;

public class DefaultTestStepProperty
implements TestStepProperty {
    private final String name;
    private boolean isReadOnly;
    private String description;
    private PropertyHandler handler;
    private final TestStep testStep;

    public DefaultTestStepProperty(String name, boolean isReadOnly, PropertyHandler handler, TestStep testStep) {
        this.name = name;
        this.isReadOnly = isReadOnly;
        this.handler = handler;
        this.testStep = testStep;
    }

    public DefaultTestStepProperty(String name, TestStep testStep) {
        this(name, false, new SimplePropertyHandler(), testStep);
    }

    public DefaultTestStepProperty(String name, boolean isReadOnly, TestStep testStep) {
        this(name, isReadOnly, new SimplePropertyHandler(), testStep);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setPropertyHandler(PropertyHandler handler) {
        this.handler = handler;
    }

    public String getValue() {
        return this.handler == null ? null : this.handler.getValue();
    }

    public void setValue(String value) {
        if (this.handler != null && !this.isReadOnly()) {
            this.handler.setValue(value);
        }
    }

    public TestStep getTestStep() {
        return this.testStep;
    }

    public static class SimplePropertyHandler
    implements PropertyHandler {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class PropertyHandlerAdapter
    implements PropertyHandler {
        public String getValue() {
            return null;
        }

        public void setValue(String value) {
        }
    }

    public static interface PropertyHandler {
        public String getValue();

        public void setValue(String var1);
    }
}

