/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.support.UISupport;
import javax.swing.ImageIcon;

public class ModelItemIconAnimator
implements Runnable {
    private final AbstractWsdlModelItem target;
    private int index = 0;
    private boolean stopped = true;
    private boolean enabled = true;
    private ImageIcon baseIcon;
    private ImageIcon[] animateIcons;
    private Thread iconAnimationThread;

    public ModelItemIconAnimator(AbstractWsdlModelItem target, String baseIcon, String[] icons) {
        this.target = target;
        this.baseIcon = UISupport.createImageIcon(baseIcon);
        this.animateIcons = new ImageIcon[icons.length];
        for (int c = 0; c < icons.length; ++c) {
            this.animateIcons[c] = UISupport.createImageIcon(icons[c]);
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void start() {
        if (!this.enabled || this.iconAnimationThread != null) {
            return;
        }
        this.stopped = false;
        this.iconAnimationThread = new Thread(this);
        this.iconAnimationThread.start();
    }

    public ImageIcon getBaseIcon() {
        return this.baseIcon;
    }

    public ImageIcon getIcon() {
        if (!this.isStopped()) {
            return this.animateIcons[this.getIndex()];
        }
        return this.baseIcon;
    }

    public void run() {
        while (!this.stopped) {
            try {
                if (this.stopped) break;
                this.index = this.index >= this.animateIcons.length - 1 ? 0 : this.index + 1;
                this.target.setIcon(this.getIcon());
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.target.setIcon(this.getIcon());
        this.iconAnimationThread = null;
    }

    public AbstractWsdlModelItem getTarget() {
        return this.target;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.stopped) {
            this.stopped = enabled;
        }
    }
}

