/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.impl.wsdl.testcase.TestCaseLogItem;
import com.eviware.soapui.impl.wsdl.testcase.TestCaseLogModel;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class TestCaseLog
extends JPanel {
    private TestCaseLogModel logListModel;
    private JList testLogList;

    public TestCaseLog() {
        super(new BorderLayout());
        this.buildUI();
    }

    private void buildUI() {
        this.logListModel = new TestCaseLogModel();
        this.testLogList = new JList(this.logListModel);
        this.testLogList.setCellRenderer(new TestLogCellRenderer());
        this.testLogList.setPrototypeCellValue("Testing 123");
        this.testLogList.setFixedCellWidth(-1);
        this.testLogList.addMouseListener(new LogListMouseListener());
        this.testLogList.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JScrollPane scrollPane = new JScrollPane(this.testLogList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Test Log"));
        this.add((Component)scrollPane, "Center");
    }

    public void clear() {
        this.logListModel.clear();
    }

    public void addText(String string) {
        this.logListModel.addText(string);
    }

    public void addTestStepResult(TestStepResult stepResult) {
        this.logListModel.addTestStepResult(stepResult);
    }

    public TestCaseLogModel getLogListModel() {
        return this.logListModel;
    }

    public void setLogListModel(TestCaseLogModel logListModel) {
        this.logListModel = logListModel;
        this.testLogList.setModel(logListModel);
    }

    private final class LogListMouseListener
    extends MouseAdapter {
        private LogListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            int selectedIndex = TestCaseLog.this.testLogList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            TestStepResult result = TestCaseLog.this.logListModel.getResultAt(selectedIndex);
            if (result != null && result.getActions() != null) {
                result.getActions().performDefaultAction(new ActionEvent(this, 0, null));
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void showPopup(MouseEvent e) {
            TestStepResult result;
            int row = TestCaseLog.this.testLogList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            if (TestCaseLog.this.testLogList.getSelectedIndex() != row) {
                TestCaseLog.this.testLogList.setSelectedIndex(row);
            }
            if ((result = TestCaseLog.this.logListModel.getResultAt(row)) == null) {
                return;
            }
            ActionList actions = result.getActions();
            if (actions == null || actions.getActionCount() == 0) {
                return;
            }
            JPopupMenu popup = ActionSupport.buildPopup(actions);
            UISupport.showPopup(popup, TestCaseLog.this.testLogList, e.getPoint());
        }
    }

    private static final class TestLogCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public TestLogCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.setIcon(null);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                this.setText(value.toString());
            } else if (value instanceof TestCaseLogItem) {
                TestCaseLogItem logItem = (TestCaseLogItem)value;
                String msg = logItem.getMsg();
                this.setText(msg == null ? "" : msg);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }
    }
}

