/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation.actions;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RecreateMockResponseAction
extends AbstractAction {
    private final WsdlMockResponse mockResponse;

    public RecreateMockResponseAction(WsdlMockResponse mockResponse) {
        super("Recreate response");
        this.mockResponse = mockResponse;
        this.putValue("SmallIcon", UISupport.createImageIcon("/recreate_request.gif"));
        this.putValue("ShortDescription", "Recreates a default response from the schema");
    }

    public void actionPerformed(ActionEvent arg0) {
        String req;
        WsdlOperation operation = this.mockResponse.getMockOperation().getOperation();
        if (operation == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return;
        }
        String response = this.mockResponse.getResponseContent();
        if (response != null && response.trim().length() > 0 && !UISupport.confirm("Overwrite current response?", "Recreate response")) {
            return;
        }
        boolean createOptional = this.mockResponse.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
        if (!createOptional) {
            createOptional = UISupport.confirm("Create optional elements in schema?", "Create Request");
        }
        if ((req = operation.createResponse(createOptional)) == null) {
            UISupport.showErrorMessage("Response creation failed");
            return;
        }
        this.mockResponse.setResponseContent(req);
    }
}

