/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.request;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RecreateRequestAction
extends AbstractAction {
    private final WsdlRequest request;

    public RecreateRequestAction(WsdlRequest request) {
        super("Recreate request");
        this.request = request;
        this.putValue("SmallIcon", UISupport.createImageIcon("/recreate_request.gif"));
        this.putValue("ShortDescription", "Recreates a default request from the schema");
    }

    public void actionPerformed(ActionEvent e) {
        String req;
        boolean createOptional = this.request.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
        if (!createOptional) {
            Boolean create = UISupport.confirmOrCancel("Create optional elements in schema?", "Create Request");
            if (create == null) {
                return;
            }
            createOptional = create;
        }
        if ((req = this.request.getOperation().createRequest(createOptional)) == null) {
            UISupport.showErrorMessage("Request creation failed");
            return;
        }
        if (this.request.getRequestContent() != null && this.request.getRequestContent().trim().length() > 0 && UISupport.confirm("Keep existing values", "Recreate Request")) {
            req = XmlUtils.transferValues(this.request.getRequestContent(), req);
        }
        this.request.setRequestContent(req);
    }
}

