/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.axis1;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis1XWSDL2JavaAction
extends AbstractToolsAction<Interface> {
    private static final String NAMESPACE_MAPPING = "namespace mapping";
    private static final String FACTORY = "factory";
    private static final String OUTPUT = "output directory";
    private static final String PACKAGE = "target package";
    private static final String TYPE_MAPPING_VERSION = "typeMappingVersion";
    private static final String DEPLOY_SCOPE = "deployScope";
    private static final String SKELETON_DEPLOY = "skeletonDeploy";
    private static final String WRAP_ARRAYS = "wrapArrays";
    private static final String HELPER_GEN = "helperGen";
    private static final String ALL = "all";
    private static final String TEST_CASE = "testCase";
    private static final String SERVER_SIDE = "server-side";
    private static final String NO_WRAPPED = "noWrapped";
    private static final String NO_IMPORTS = "noImports";
    private static final String IMPLCLASS = "implementationClassName";
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";

    public Axis1XWSDL2JavaAction(Interface iface) {
        super(iface, "Axis 1.X Artifacts", "Generates Axis 1.X artifacts using WSDL2Java");
    }

    @Override
    protected StringToStringMap initValues() {
        StringToStringMap values = super.initValues();
        values.putIfMissing(SKELETON_DEPLOY, "none");
        values.putIfMissing(DEPLOY_SCOPE, "none");
        values.putIfMissing(TYPE_MAPPING_VERSION, "1.2");
        return values;
    }

    @Override
    protected XFormDialog buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Axis 1.X WSDL2Java");
        XForm mainForm = builder.createForm("Basic");
        this.addWSDLFields(mainForm);
        mainForm.addTextField(OUTPUT, "The root directory for all emitted files.", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addCheckBox(SERVER_SIDE, "(emit server-side bindings for web service)");
        mainForm.addCheckBox(ALL, "(generate code for all elements, even unreferenced ones)");
        mainForm.addComboBox(DEPLOY_SCOPE, new String[]{"none", "Application", "Session", "Request"}, "add scope to deploy.wsdd");
        mainForm.addComboBox(SKELETON_DEPLOY, new String[]{"none", "true", "false"}, "deploy skeleton (true) or implementation (false) in deploy.wsdd");
        mainForm.addCheckBox(NO_IMPORTS, "(only generate code for immediate WSDL document)");
        mainForm.addCheckBox(NO_WRAPPED, "(turn off support for \"wrapped\" document/literal)");
        mainForm.addCheckBox(TEST_CASE, "(emit junit testcase class for web service)");
        mainForm.addCheckBox(HELPER_GEN, "(emits separate Helper classes for meta data)");
        mainForm.addCheckBox(WRAP_ARRAYS, "(Prefer generating JavaBean classes for certain schema array patterns)");
        XForm advForm = builder.createForm("Advanced");
        advForm.addComboBox(TYPE_MAPPING_VERSION, new String[]{"1.2", "1.1"}, "typeMapping version to use");
        advForm.addTextField(IMPLCLASS, "use this as the implementation class", XForm.FieldType.JAVA_CLASS);
        advForm.addTextField(FACTORY, "the name of a class which extends JavaWriterFactory", XForm.FieldType.JAVA_CLASS);
        advForm.addTextField(PACKAGE, "maps all namespaces in a WSDL document to the same Java package name", XForm.FieldType.JAVA_PACKAGE);
        advForm.addNameSpaceTable(NAMESPACE_MAPPING, (Interface)this.modelItem);
        advForm.addTextField(USERNAME, "username to access the WSDL-URI", XForm.FieldType.TEXT);
        advForm.addTextField(PASSWORD, "password to access the WSDL-URI", XForm.FieldType.TEXT);
        XForm argsForm = this.buildArgsForm(builder, true, "WSDL2Java");
        return builder.buildDialog(this.buildDefaultActions("http://ws.apache.org/axis/java/reference.html#WSDL2JavaReference"), "Specify arguments for Axis 1.X Wsdl2Java", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost) throws Exception {
        String axisDir = SoapUI.getSettings().getString(ToolsSettings.AXIS_1_X_LOCATION, null);
        if (Tools.isEmpty(axisDir)) {
            UISupport.showErrorMessage("Axis 1.X location must be set in global preferences");
            return;
        }
        File axisLibDir = new File(axisDir + File.separatorChar + "lib");
        if (!axisLibDir.exists()) {
            UISupport.showErrorMessage("Could not find Axis 1.X lib directory [" + axisLibDir + "]");
            return;
        }
        String classpath = this.buildClasspath(axisLibDir);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(classpath, values);
        builder.command(args.getArgs());
        builder.directory(axisLibDir);
        toolHost.run(new ProcessToolRunner(builder, "Axis 1.x wsdl2java", this.modelItem));
    }

    private ArgumentBuilder buildArgs(String classpath, StringToStringMap values) {
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.addArgs("java");
        this.addJavaArgs(values, builder);
        builder.addArgs("-cp", classpath, "org.apache.axis.wsdl.WSDL2Java", "-v");
        builder.addBoolean(NO_IMPORTS, "-n");
        builder.addBoolean(NO_WRAPPED, "-W");
        builder.addBoolean(SERVER_SIDE, "-s");
        builder.addBoolean(TEST_CASE, "-t");
        builder.addBoolean(ALL, "-a");
        builder.addBoolean(HELPER_GEN, "-H");
        builder.addBoolean(WRAP_ARRAYS, "-w");
        if (!((String)values.get(SKELETON_DEPLOY)).equals("none")) {
            builder.addString(SKELETON_DEPLOY, "-S");
        }
        if (!((String)values.get(DEPLOY_SCOPE)).equals("none")) {
            builder.addString(DEPLOY_SCOPE, "-d");
        }
        values.put(OUTPUT, Tools.ensureDir((String)values.get(OUTPUT)));
        builder.addString(TYPE_MAPPING_VERSION, "-T");
        builder.addString(PACKAGE, "-p");
        builder.addString(OUTPUT, "-o");
        builder.addString(FACTORY, "-F");
        builder.addString(IMPLCLASS, "-c");
        builder.addString(USERNAME, "-U");
        builder.addString(PASSWORD, "-P");
        try {
            StringToStringMap nsMappings = StringToStringMap.fromXml((String)values.get(NAMESPACE_MAPPING));
            for (String namespace : nsMappings.keySet()) {
                builder.addArgs("-N" + namespace + "=" + (String)nsMappings.get(namespace));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addToolArgs(values, builder);
        builder.addArgs(this.getWsdlUrl(values));
        return builder;
    }
}

