/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.MessageResource;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageResourceImpl
implements MessageResource,
Component {
    private final Logger LOG = LoggerFactory.getLogger((Class)MessageResourceImpl.class);
    private static final String RESOURCE_PATH = "org/apache/ftpserver/message/";
    private String[] languages;
    private HashMap messages;
    private String customMessageDir;

    public void configure(Configuration config) throws FtpException {
        this.customMessageDir = config.getString("custom-message-dir", "./res");
        String languages = config.getString("languages", null);
        if (languages != null) {
            StringTokenizer st = new StringTokenizer(languages, ",; \t");
            int tokenCount = st.countTokens();
            this.languages = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                this.languages[i] = st.nextToken().toLowerCase();
            }
        }
        this.messages = new HashMap();
        if (this.languages != null) {
            for (int i = 0; i < this.languages.length; ++i) {
                String lang = this.languages[i];
                PropertiesPair pair = this.createPropertiesPair(lang);
                this.messages.put(lang, pair);
            }
        }
        PropertiesPair pair = this.createPropertiesPair(null);
        this.messages.put(null, pair);
    }

    private PropertiesPair createPropertiesPair(String lang) throws FtpException {
        PropertiesPair pair = new PropertiesPair();
        String defaultResourceName = lang == null ? "org/apache/ftpserver/message/FtpStatus.properties" : "org/apache/ftpserver/message/FtpStatus_" + lang + ".properties";
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(defaultResourceName);
            if (in != null) {
                pair.defaultProperties.load(in);
            }
        }
        catch (Exception ex) {
            try {
                this.LOG.warn("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
                throw new FtpException("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                throw throwable;
            }
        }
        IoUtils.close(in);
        File resourceFile = null;
        resourceFile = lang == null ? new File(this.customMessageDir, "FtpStatus.gen") : new File(this.customMessageDir, "FtpStatus_" + lang + ".gen");
        in = null;
        try {
            if (resourceFile.exists()) {
                in = new FileInputStream(resourceFile);
                pair.customProperties.load(in);
            }
        }
        catch (Exception ex) {
            this.LOG.warn("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
            throw new FtpException("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
        }
        finally {
            IoUtils.close(in);
        }
        return pair;
    }

    public String[] getAvailableLanguages() {
        if (this.languages == null) {
            return null;
        }
        return (String[])this.languages.clone();
    }

    public String getMessage(int code, String subId, String language) {
        String key = String.valueOf(code);
        if (subId != null) {
            key = key + '.' + subId;
        }
        String value = null;
        PropertiesPair pair = null;
        if (language != null && (pair = (PropertiesPair)this.messages.get(language = language.toLowerCase())) != null && (value = pair.customProperties.getProperty(key)) == null) {
            value = pair.defaultProperties.getProperty(key);
        }
        if (value == null && (pair = (PropertiesPair)this.messages.get(null)) != null && (value = pair.customProperties.getProperty(key)) == null) {
            value = pair.defaultProperties.getProperty(key);
        }
        return value;
    }

    public Properties getMessages(String language) {
        Properties messages = new Properties();
        PropertiesPair pair = (PropertiesPair)this.messages.get(null);
        if (pair != null) {
            messages.putAll((Map<?, ?>)pair.defaultProperties);
            messages.putAll((Map<?, ?>)pair.customProperties);
        }
        if (language != null && (pair = (PropertiesPair)this.messages.get(language = language.toLowerCase())) != null) {
            messages.putAll((Map<?, ?>)pair.defaultProperties);
            messages.putAll((Map<?, ?>)pair.customProperties);
        }
        return messages;
    }

    public void save(Properties prop, String language) throws FtpException {
        if (prop == null) {
            return;
        }
        if (prop.isEmpty()) {
            return;
        }
        File resourceFile = null;
        if (language == null) {
            resourceFile = new File(this.customMessageDir, "FtpStatus.gen");
        } else {
            language = language.toLowerCase();
            resourceFile = new File(this.customMessageDir, "FtpStatus_" + language + ".gen");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(resourceFile);
            prop.store(out, "Custom Messages");
        }
        catch (IOException ex) {
            try {
                this.LOG.error("MessageResourceImpl.save()", (Throwable)ex);
                throw new FtpException("MessageResourceImpl.save()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close(out);
        PropertiesPair pair = (PropertiesPair)this.messages.get(language);
        if (pair == null) {
            pair = new PropertiesPair();
            this.messages.put(language, pair);
        }
        pair.customProperties = prop;
    }

    public void dispose() {
        Iterator it = this.messages.keySet().iterator();
        while (it.hasNext()) {
            String language = (String)it.next();
            PropertiesPair pair = (PropertiesPair)this.messages.get(language);
            pair.customProperties.clear();
            pair.defaultProperties.clear();
        }
        this.messages.clear();
    }

    private static class PropertiesPair {
        public Properties defaultProperties = new Properties();
        public Properties customProperties = new Properties();

        private PropertiesPair() {
        }
    }
}

