/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.IODataConnection;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.DataConnectionConfig;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.Ssl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IODataConnectionFactory
implements ServerDataConnectionFactory {
    static final Logger LOG = LoggerFactory.getLogger((Class)IODataConnectionFactory.class);
    private FtpServerContext serverContext;
    private Socket dataSoc;
    ServerSocket servSoc;
    InetAddress address;
    int port = 0;
    long requestTime = 0L;
    boolean isPort = false;
    boolean isPasv = false;
    boolean secure = false;
    private boolean isZip = false;
    InetAddress serverControlAddress;
    FtpSessionImpl session;

    public IODataConnectionFactory(FtpServerContext serverContext, FtpSessionImpl session) {
        this.session = session;
        this.serverContext = serverContext;
    }

    public synchronized void closeDataConnection() {
        if (this.dataSoc != null) {
            try {
                this.dataSoc.close();
            }
            catch (Exception ex) {
                LOG.warn("FtpDataConnection.closeDataSocket()", (Throwable)ex);
            }
            this.dataSoc = null;
        }
        if (this.servSoc != null) {
            DataConnectionConfig dcc;
            try {
                this.servSoc.close();
            }
            catch (Exception ex) {
                LOG.warn("FtpDataConnection.closeDataSocket()", (Throwable)ex);
            }
            FtpServerContext ctx = this.serverContext;
            if (ctx != null && (dcc = this.session.getListener().getDataConnectionConfig()) != null) {
                dcc.releasePassivePort(this.port);
            }
            this.servSoc = null;
        }
        this.requestTime = 0L;
    }

    public synchronized void setPortCommand(InetAddress addr, int activePort) {
        this.closeDataConnection();
        this.isPort = true;
        this.isPasv = false;
        this.address = addr;
        this.port = activePort;
        this.requestTime = System.currentTimeMillis();
    }

    public synchronized boolean setPasvCommand() {
        this.closeDataConnection();
        int passivePort = this.session.getListener().getDataConnectionConfig().getPassivePort();
        if (passivePort == -1) {
            LOG.warn("Cannot find an available passive port.");
            this.servSoc = null;
            return false;
        }
        boolean bRet = false;
        try {
            DataConnectionConfig dataCfg = this.session.getListener().getDataConnectionConfig();
            this.address = dataCfg.getPassiveAddress();
            if (this.address == null) {
                this.address = this.serverControlAddress;
            }
            if (this.secure) {
                Ssl ssl = dataCfg.getSSL();
                if (ssl == null) {
                    throw new FtpException("Data connection SSL not configured.");
                }
                this.servSoc = ssl.createServerSocket(null, this.address, passivePort);
            } else {
                this.servSoc = new ServerSocket(passivePort, 1, this.address);
            }
            this.servSoc.setSoTimeout(dataCfg.getMaxIdleTimeMillis());
            this.port = this.servSoc.getLocalPort();
            this.isPort = false;
            this.isPasv = true;
            bRet = true;
            this.requestTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            this.servSoc = null;
            this.closeDataConnection();
            LOG.warn("FtpDataConnection.setPasvCommand()", (Throwable)ex);
        }
        return bRet;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public DataConnection openConnection() throws Exception {
        return new IODataConnection(this.getDataSocket(), this.session, this);
    }

    private synchronized Socket getDataSocket() throws Exception {
        this.dataSoc = null;
        DataConnectionConfig dataConfig = this.session.getListener().getDataConnectionConfig();
        try {
            if (this.isPort) {
                int localPort = dataConfig.getActiveLocalPort();
                if (this.secure) {
                    Ssl ssl = dataConfig.getSSL();
                    if (ssl == null) {
                        throw new FtpException("Data connection SSL not configured");
                    }
                    if (localPort == 0) {
                        this.dataSoc = ssl.createSocket(null, this.address, this.port, false);
                    } else {
                        InetAddress localAddr = dataConfig.getActiveLocalAddress();
                        this.dataSoc = ssl.createSocket(null, this.address, this.port, localAddr, localPort, false);
                    }
                } else if (localPort == 0) {
                    this.dataSoc = new Socket(this.address, this.port);
                } else {
                    InetAddress localAddr = dataConfig.getActiveLocalAddress();
                    this.dataSoc = new Socket(this.address, this.port, localAddr, localPort);
                }
            } else if (this.isPasv) {
                this.dataSoc = this.servSoc.accept();
            }
        }
        catch (Exception ex) {
            this.closeDataConnection();
            LOG.warn("FtpDataConnection.getDataSocket()", (Throwable)ex);
            throw ex;
        }
        if (this.dataSoc instanceof SSLSocket) {
            ((SSLSocket)this.dataSoc).startHandshake();
        }
        return this.dataSoc;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isZipMode() {
        return this.isZip;
    }

    public void setZipMode(boolean zip) {
        this.isZip = zip;
    }

    public synchronized boolean isTimeout(long currTime) {
        if (this.requestTime == 0L) {
            return false;
        }
        if (this.dataSoc != null) {
            return false;
        }
        int maxIdleTime = this.session.getListener().getDataConnectionConfig().getMaxIdleTimeMillis();
        if (maxIdleTime == 0) {
            return false;
        }
        return currTime - this.requestTime >= (long)maxIdleTime;
    }

    public void dispose() {
        this.closeDataConnection();
    }

    public void setServerControlAddress(InetAddress serverControlAddress) {
        this.serverControlAddress = serverControlAddress;
    }
}

