/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import org.apache.ftpserver.DefaultFtpServerContext;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpServer {
    private final Logger LOG = LoggerFactory.getLogger((Class)FtpServer.class);
    private FtpServerContext serverContext;
    private boolean suspended;
    private boolean started = false;

    public FtpServer() throws Exception {
        this.serverContext = new DefaultFtpServerContext();
    }

    public FtpServer(FtpServerContext serverContext) throws Exception {
        this.serverContext = serverContext;
    }

    public void start() throws Exception {
        Listener[] listeners = this.serverContext.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].start(this.serverContext);
        }
        this.started = true;
        System.out.println("Server ready :: Apache FTP Server");
        this.LOG.info("------- Apache FTP Server started ------");
    }

    public void stop() {
        Listener[] listeners = this.serverContext.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stop();
        }
        if (this.serverContext != null) {
            this.serverContext.dispose();
            this.serverContext = null;
        }
        this.started = false;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void suspend() {
        Listener[] listeners = this.serverContext.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].suspend();
        }
        this.suspended = true;
    }

    public void resume() {
        Listener[] listeners = this.serverContext.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].resume();
        }
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public FtpServerContext getServerContext() {
        return this.serverContext;
    }
}

