/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ftpserver.Bean;
import org.apache.ftpserver.DefaultCommandFactory;
import org.apache.ftpserver.FtpStatisticsImpl;
import org.apache.ftpserver.filesystem.NativeFileSystemManager;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.DefaultFtpletContainer;
import org.apache.ftpserver.ftplet.EmptyConfiguration;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.FtpStatistics;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.IpRestrictor;
import org.apache.ftpserver.interfaces.MessageResource;
import org.apache.ftpserver.iprestrictor.FileIpRestrictor;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.listener.ConnectionManagerImpl;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.mina.MinaListener;
import org.apache.ftpserver.message.MessageResourceImpl;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.PropertiesUserManager;
import org.apache.ftpserver.usermanager.TransferRatePermission;
import org.apache.ftpserver.usermanager.WritePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFtpServerContext
implements FtpServerContext {
    private final Logger LOG = LoggerFactory.getLogger((Class)DefaultFtpServerContext.class);
    private MessageResource messageResource;
    private ConnectionManager connectionManager;
    private IpRestrictor ipRestrictor;
    private UserManager userManager;
    private FileSystemManager fileSystemManager;
    private FtpletContainer ftpletContainer;
    private FtpStatistics statistics;
    private CommandFactory commandFactory;
    private Map listeners = new HashMap();
    private static final Authority[] ADMIN_AUTHORITIES = new Authority[]{new WritePermission()};
    private static final Authority[] ANON_AUTHORITIES = new Authority[]{new ConcurrentLoginPermission(20, 2), new TransferRatePermission(4800, 4800)};

    public DefaultFtpServerContext() throws Exception {
        this(true);
    }

    public DefaultFtpServerContext(boolean createDefaultUsers) throws Exception {
        try {
            this.createListeners();
            this.messageResource = new MessageResourceImpl();
            ((MessageResourceImpl)this.messageResource).configure(EmptyConfiguration.INSTANCE);
            this.connectionManager = new ConnectionManagerImpl();
            ((ConnectionManagerImpl)this.connectionManager).configure(EmptyConfiguration.INSTANCE);
            this.ipRestrictor = new FileIpRestrictor();
            ((FileIpRestrictor)this.ipRestrictor).configure(EmptyConfiguration.INSTANCE);
            this.userManager = new PropertiesUserManager();
            ((PropertiesUserManager)this.userManager).configure();
            this.fileSystemManager = new NativeFileSystemManager();
            ((NativeFileSystemManager)this.fileSystemManager).configure(EmptyConfiguration.INSTANCE);
            this.statistics = new FtpStatisticsImpl();
            ((FtpStatisticsImpl)this.statistics).configure(EmptyConfiguration.INSTANCE);
            this.commandFactory = new DefaultCommandFactory();
            ((DefaultCommandFactory)this.commandFactory).configure(EmptyConfiguration.INSTANCE);
            if (createDefaultUsers) {
                this.createDefaultUsers();
            }
            this.ftpletContainer = new DefaultFtpletContainer();
            ((DefaultFtpletContainer)this.ftpletContainer).configure(EmptyConfiguration.INSTANCE);
        }
        catch (Exception ex) {
            this.dispose();
            throw ex;
        }
    }

    private void createListeners() throws Exception {
        this.listeners.put("default", new MinaListener());
    }

    private void createDefaultUsers() throws Exception {
        String adminName;
        UserManager userManager = this.getUserManager();
        if (!userManager.doesExist(adminName = userManager.getAdminName())) {
            this.LOG.info("Creating user : " + adminName);
            BaseUser adminUser = new BaseUser();
            adminUser.setName(adminName);
            adminUser.setPassword(adminName);
            adminUser.setEnabled(true);
            adminUser.setAuthorities(ADMIN_AUTHORITIES);
            adminUser.setHomeDirectory("./res/home");
            adminUser.setMaxIdleTime(0);
            userManager.save((User)adminUser);
        }
        if (!userManager.doesExist("anonymous")) {
            this.LOG.info("Creating user : anonymous");
            BaseUser anonUser = new BaseUser();
            anonUser.setName("anonymous");
            anonUser.setPassword("");
            anonUser.setAuthorities(ANON_AUTHORITIES);
            anonUser.setEnabled(true);
            anonUser.setHomeDirectory("./res/home");
            anonUser.setMaxIdleTime(300);
            userManager.save((User)anonUser);
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public IpRestrictor getIpRestrictor() {
        return this.ipRestrictor;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public MessageResource getMessageResource() {
        return this.messageResource;
    }

    public FtpStatistics getFtpStatistics() {
        return this.statistics;
    }

    public void setFtpStatistics(FtpStatistics statistics) {
        this.statistics = statistics;
    }

    public Ftplet getFtpletContainer() {
        return this.ftpletContainer;
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public Ftplet getFtplet(String name) {
        return this.ftpletContainer.getFtplet(name);
    }

    public void dispose() {
        Iterator listenerIter = this.listeners.values().iterator();
        while (listenerIter.hasNext()) {
            Bean listenerBean = (Bean)listenerIter.next();
            listenerBean.destroyBean();
        }
        if (this.connectionManager != null && this.connectionManager instanceof Component) {
            ((Component)this.connectionManager).dispose();
        }
        if (this.ftpletContainer != null && this.ftpletContainer instanceof Component) {
            ((Component)this.ftpletContainer).dispose();
        }
        if (this.userManager != null && this.userManager instanceof Component) {
            ((Component)this.userManager).dispose();
        }
        if (this.ipRestrictor != null && this.ipRestrictor instanceof Component) {
            ((Component)this.ipRestrictor).dispose();
        }
        if (this.fileSystemManager != null && this.fileSystemManager instanceof Component) {
            ((Component)this.fileSystemManager).dispose();
        }
        if (this.statistics != null && this.statistics instanceof Component) {
            ((Component)this.statistics).dispose();
        }
        if (this.messageResource != null && this.messageResource instanceof Component) {
            ((Component)this.messageResource).dispose();
        }
    }

    public Listener getListener(String name) {
        return (Listener)this.listeners.get(name);
    }

    public Listener[] getListeners() {
        Collection listenerList = this.listeners.values();
        Listener[] listenerArray = new Listener[]{};
        return listenerList.toArray(listenerArray);
    }

    public void addListener(String name, Listener listener) {
        this.listeners.put(name, listener);
    }

    public Listener removeListener(String name) {
        return (Listener)this.listeners.remove(name);
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public void setFtpletContainer(FtpletContainer ftpletContainer) {
        this.ftpletContainer = ftpletContainer;
    }

    public void setIpRestrictor(IpRestrictor ipRestrictor) {
        this.ipRestrictor = ipRestrictor;
    }

    public void setMessageResource(MessageResource messageResource) {
        this.messageResource = messageResource;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

