/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Task;
import org.jboss.soa.distdiff.DirCrawler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DupFinder
extends Task {
    File distDir = null;

    public void setDistDir(File dir) {
        this.distDir = dir;
    }

    public void execute() {
        DirCrawler crawler = new DirCrawler();
        HashMap<String, List<String>> duplicateJars = new HashMap<String, List<String>>();
        HashMap<String, List<String>> duplicateZipEntries = new HashMap<String, List<String>>();
        crawler.crawl(this.distDir, duplicateJars, duplicateZipEntries);
        this.printReport(duplicateJars, "Duplicate JARs found");
        this.printReport(duplicateZipEntries, "Duplicate ZIP entries found");
    }

    private void printReport(Map<String, List<String>> found, String title) {
        int count = 0;
        System.out.println("================================================================================");
        System.out.println(title);
        for (String i : found.keySet()) {
            List<String> locations = found.get(i);
            if (locations.size() == 1) continue;
            ++count;
            System.out.println("\t" + i);
            for (String j : locations) {
                System.out.println("\t\t" + j);
            }
        }
        if (count == 0) {
            System.out.println("\tNone");
        }
        System.out.println("================================================================================");
    }
}

