/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.event.ConfigurationChangeEvent;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationMgr;

class DelayConfigInitThread
extends Thread {
    private XMLConfigurationMgr mgr;
    private static final int ERROR_DELAY_INIT_WAIT_TIME = 10000;
    private static final int CONFIG_DELAY_INIT_WAIT_TIME = 500;
    private static final int LOG_DELAY_INIT_WAIT_TIME = 60000;
    private static final int MAX_DELAY_INIT_WAIT_TIME = 600000;

    DelayConfigInitThread(XMLConfigurationMgr theMgr) {
        super("DelayConfigInitThread");
        this.mgr = theMgr;
    }

    public void run() {
        try {
            try {
                String hostName = VMNaming.getLogicalHostName();
                this.mgr.setHostName(hostName);
            }
            catch (Exception he) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0125"));
                return;
            }
            VMMessageBus messageBus = this.getMessageBus();
            this.mgr.setMessageBus(messageBus);
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0126"));
        }
    }

    private VMMessageBus getMessageBus() throws Exception {
        boolean done = false;
        VMMessageBus bus = null;
        int tryCount = 0;
        int totalWaitTime = 0;
        while (!done) {
            ++tryCount;
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            if (totalWaitTime >= 600000) {
                throw new ConfigurationException("ERR.014.002.0193", PlatformPlugin.Util.getString("ERR.014.002.0193", (Object)new Integer(totalWaitTime), (Object)new Integer(600000)));
            }
            if (!CurrentConfiguration.hasPerformedBootStrap() || VMNaming.getVMPort() == -1 || !VMMessageBus.isInitialized()) {
                DelayConfigInitThread.sleep(500L);
                totalWaitTime += 500;
            }
            if (tryCount * 500 >= 60000) {
                tryCount = 0;
                System.err.println(PlatformPlugin.Util.getString("ERR.014.002.0192", totalWaitTime));
            }
            if ((!CurrentConfiguration.hasPerformedBootStrap() || VMNaming.getVMPort() == -1) && !VMMessageBus.isInitialized()) continue;
            try {
                bus = new VMMessageBus();
                bus.addListener(ConfigurationChangeEvent.class, this.mgr.createChangeListener());
                done = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                DelayConfigInitThread.sleep(10000L);
                totalWaitTime += 10000;
            }
        }
        return bus;
    }
}

