/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.ObjectSocket;
import com.metamatrix.common.comm.platform.socket.SocketConnectionProtocol;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.packet.Packet;
import com.metamatrix.common.comm.platform.socket.packet.PacketSerializer;
import com.metamatrix.core.io.ObjectInputStreamWithClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.net.Socket;
import java.net.SocketAddress;

public class ObjectSocketImpl
implements ObjectSocket {
    private Socket socket;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private SocketLog log;
    private boolean open = false;

    public ObjectSocketImpl(Socket socket, SocketLog log, ClassLoader cl, int inputBufferSize, int outputBufferSize) throws CommunicationException, IOException {
        this.log = log;
        this.socket = socket;
        try {
            int socketTimeout = socket.getSoTimeout();
            socket.setSoTimeout(2000);
            this.outputStream = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream(), outputBufferSize));
            this.outputStream.flush();
            BufferedInputStream bis = new BufferedInputStream(socket.getInputStream(), inputBufferSize);
            this.inputStream = new ObjectInputStreamWithClassLoader(bis, cl);
            socket.setSoTimeout(socketTimeout);
        }
        catch (StreamCorruptedException e) {
            throw new CommunicationException((Throwable)e);
        }
    }

    public synchronized void initialize(SocketConnectionProtocol protocol) throws CommunicationException, IOException {
        protocol.handshake(this.socket, this.inputStream, this.outputStream);
        this.open = true;
    }

    public synchronized void write(Packet packet) throws CommunicationException {
        if (!this.open) {
            throw new CommunicationException(CommPlatformPlugin.Util.getString("ObjectSocket.write_on_closed_socket"));
        }
        this.logDetail("ObjectSocket.write", packet);
        try {
            PacketSerializer serializer = packet.getSerializer();
            this.outputStream.writeObject(serializer);
            serializer.writePacketBody(packet, (ObjectOutput)this.outputStream);
            this.outputStream.flush();
            this.outputStream.reset();
            this.log.logDetail("ObjectSocket.write", "written");
        }
        catch (OptionalDataException e) {
            this.close();
            throw new CommunicationException((Throwable)e);
        }
        catch (IOException e) {
            this.close();
            throw new CommunicationException((Throwable)e);
        }
    }

    public Packet read() throws CommunicationException, EOFException {
        if (!this.open) {
            throw new CommunicationException(CommPlatformPlugin.Util.getString("ObjectSocket.read_on_closed_socket"));
        }
        try {
            this.log.logDetail("ObjectSocket.read", "reading");
            Packet packet = null;
            try {
                PacketSerializer serializer = (PacketSerializer)this.inputStream.readObject();
                packet = serializer.createPacket((ObjectInput)this.inputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.logDetail("ObjectSocket.read", packet);
            return packet;
        }
        catch (EOFException e) {
            this.close();
            throw e;
        }
        catch (OptionalDataException e) {
            this.close();
            throw new CommunicationException((Throwable)e);
        }
        catch (IOException e) {
            this.close();
            throw new CommunicationException((Throwable)e);
        }
    }

    private void logDetail(String context, Object message) {
        if (!this.log.isLogged(context, 5)) {
            return;
        }
        if (message instanceof Object[]) {
            this.log.logDetail(context, "message is of type Object[]");
            Object[] objects = (Object[])message;
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) {
                    this.log.logDetail(context, "[" + i + "] null");
                    continue;
                }
                this.log.logDetail(context, "[" + i + "]" + objects[i].getClass().getName() + " '" + objects[i].toString() + "'");
            }
        } else {
            this.log.logDetail(context, message.getClass().getName() + " '" + message.toString() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws CommunicationException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.log.logDetail("ObjectSocket.close", "");
        try {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new CommunicationException((Throwable)e);
            }
        }
        finally {
            this.socket = null;
            this.outputStream = null;
            this.inputStream = null;
        }
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }
}

