/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.navigator.AggregateStopNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleAssignOutputElements
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(plan, 11);
        if (projectNode == null) {
            return plan;
        }
        if (projectNode.getChildren() == null || projectNode.getChildren().isEmpty()) {
            boolean foundUnion = false;
            for (PlanNode searchNode = projectNode.getParent(); searchNode != null; searchNode = searchNode.getParent()) {
                if (searchNode.getType() != 29) continue;
                foundUnion = true;
                break;
            }
            if (!foundUnion) {
                projectNode.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
                return plan;
            }
        }
        List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        this.assignOutputElements(plan, projectCols, metadata, capFinder, rules, analysisRecord, context);
        return plan;
    }

    void assignOutputElements(PlanNode root, List outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        block16: {
            int nodeType;
            block18: {
                block17: {
                    block15: {
                        nodeType = root.getType();
                        if (outputElements.isEmpty() && (nodeType == 3 || nodeType == 19)) {
                            PlanNode groupSource = FrameUtil.findJoinSourceNode(root);
                            this.selectOutputElement(groupSource.getGroups(), metadata, outputElements);
                        }
                        root.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, (Object)outputElements);
                        if (nodeType != 3) break block15;
                        if (root.getChildCount() == 0) {
                            return;
                        }
                        this.assignOutputElements(root.getLastChild(), outputElements, metadata, capFinder, rules, analysisRecord, context);
                        break block16;
                    }
                    if (nodeType != 19) break block17;
                    if (root.getChildCount() == 0) {
                        return;
                    }
                    if (!root.hasBooleanProperty((Object)NodeConstants.Info.INLINE_VIEW) && root.getFirstChild().getType() == 41 && root.getFirstChild().getFirstChild().getType() == 17) {
                        LinkedHashSet elements = new LinkedHashSet(outputElements);
                        PlanNode sort = root.getFirstChild().getFirstChild();
                        List sortOrder = (List)sort.getProperty((Object)NodeConstants.Info.SORT_ORDER);
                        Map symbolMap = (Map)root.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                        elements.addAll(RuleAssignOutputElements.reverseSymbolLookup(sortOrder, symbolMap));
                        root.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, new ArrayList(elements));
                    }
                    PlanNode virtualRoot = root.getLastChild();
                    boolean overAccess = false;
                    if (virtualRoot.getType() == 3 && virtualRoot.getChildCount() == 1) {
                        virtualRoot = virtualRoot.getFirstChild();
                        overAccess = true;
                    }
                    if (this.hasDupRemoval(virtualRoot)) {
                        Map symbolMap = (Map)root.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                        ArrayList removedSymbols = new ArrayList();
                        List newOutputElements = this.createOrderedOutputElements(symbolMap.keySet(), this.findTopCols(virtualRoot, NodeConstants.Info.TOP_COLS));
                        root.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, (Object)newOutputElements);
                        if (!removedSymbols.isEmpty()) {
                            this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.TOP_COLS);
                            this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.OUTPUT_COLS);
                            this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.PROJECT_COLS);
                        }
                    }
                    if (overAccess) {
                        virtualRoot = virtualRoot.getParent();
                    }
                    this.assignOutputElements(virtualRoot, this.filterVirtualElements(root, metadata), metadata, capFinder, rules, analysisRecord, context);
                    break block16;
                }
                if (nodeType != 29) break block18;
                for (PlanNode childNode : root.getChildren()) {
                    PlanNode projectNode = NodeEditor.findNodePreOrder(childNode, 11);
                    List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                    this.assignOutputElements(childNode, projectCols, metadata, capFinder, rules, analysisRecord, context);
                }
                break block16;
            }
            if (nodeType == 31) break block16;
            GroupSymbol intoGroup = (GroupSymbol)root.getProperty((Object)NodeConstants.Info.INTO_GROUP);
            if (intoGroup != null) {
                PlanNode intoRoot = root.getFirstChild();
                if (intoRoot.getType() == 19 && intoRoot.getChildCount() > 0) {
                    intoRoot = intoRoot.getFirstChild();
                }
                this.execute(intoRoot, metadata, capFinder, rules, analysisRecord, context);
                return;
            }
            ArrayList requiredInput = new ArrayList();
            HashSet created = new HashSet();
            this.collectRequiredInputSymbols(root, requiredInput, created);
            for (Object currentOutputSymbol : outputElements) {
                if (created.contains(currentOutputSymbol) || requiredInput.contains(currentOutputSymbol)) continue;
                requiredInput.add(currentOutputSymbol);
            }
            if (root.getChildCount() == 1) {
                this.assignOutputElements(root.getLastChild(), requiredInput, metadata, capFinder, rules, analysisRecord, context);
            } else {
                for (PlanNode childNode : root.getChildren()) {
                    List filteredElements = this.collectFilteredElements(requiredInput, FrameUtil.findJoinSourceNode(childNode).getGroups());
                    this.assignOutputElements(childNode, filteredElements, metadata, capFinder, rules, analysisRecord, context);
                }
            }
        }
    }

    private void selectOutputElement(Collection groups, QueryMetadataInterface metadata, List outputElements) throws QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol group = null;
        ElementSymbol element = null;
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext() && group == null) {
            group = (GroupSymbol)groupIter.next();
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            if (elementIDs.size() > 0) {
                Iterator elementIter = elementIDs.iterator();
                while (elementIter.hasNext() && element == null) {
                    Object elementID = elementIter.next();
                    String fullName = metadata.getFullName(elementID);
                    String shortName = metadata.getShortElementName(fullName);
                    String elementName = metadata.getFullElementName(group.getName(), shortName);
                    element = new ElementSymbol(elementName);
                    element.setGroupSymbol(group);
                    element.setMetadataID(elementID);
                    element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(elementID)));
                    if (metadata.elementSupports(element.getMetadataID(), 0)) continue;
                    element = null;
                }
            }
            if (element != null) continue;
            group = null;
        }
        if (element != null) {
            outputElements.add(element);
        }
    }

    private List createOrderedOutputElements(Set virtualCols, List topCols) {
        if (topCols == null) {
            return new ArrayList(virtualCols);
        }
        HashSet remainingVirtual = new HashSet(virtualCols);
        ArrayList<SingleElementSymbol> newCols = new ArrayList<SingleElementSymbol>();
        block0: for (SingleElementSymbol topSymbol : topCols) {
            String shortName = topSymbol.getShortCanonicalName();
            Iterator virtualIter = remainingVirtual.iterator();
            while (virtualIter.hasNext()) {
                SingleElementSymbol virtualSymbol = (SingleElementSymbol)virtualIter.next();
                if (!virtualSymbol.getShortCanonicalName().equals(shortName)) continue;
                newCols.add(virtualSymbol);
                virtualIter.remove();
                continue block0;
            }
        }
        return newCols;
    }

    private void removeUnusedColumnsInVirtualRoot(PlanNode sourceNode, List removedSymbols, Integer nodeProperty) {
        PlanNode virtualRoot = sourceNode.getLastChild();
        List cols = this.findTopCols(virtualRoot, nodeProperty);
        if (cols == null) {
            return;
        }
        block0: for (int i = 0; i < removedSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)removedSymbols.get(i);
            String shortName = symbol.getShortName();
            for (SingleElementSymbol topCol : new ArrayList(cols)) {
                if (!shortName.equalsIgnoreCase(topCol.getShortName())) continue;
                cols.remove(topCol);
                continue block0;
            }
        }
    }

    List filterVirtualElements(PlanNode sourceNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        int i;
        PlanNode virtualRoot = sourceNode.getLastChild();
        List outputColumns = (List)sourceNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
        List allProjects = NodeEditor.findAllNodes(virtualRoot, 11, 11);
        int[] unfilteredIndices = null;
        if (outputColumns == null || outputColumns.size() == 0) {
            unfilteredIndices = new int[]{0};
        } else {
            List topCols = this.findTopCols(virtualRoot, NodeConstants.Info.TOP_COLS);
            unfilteredIndices = new int[outputColumns.size()];
            if (topCols == null) {
                for (i = 0; i < outputColumns.size(); ++i) {
                    unfilteredIndices[i] = i;
                }
            } else {
                for (i = 0; i < outputColumns.size(); ++i) {
                    unfilteredIndices[i] = -1;
                    SingleElementSymbol symbol = (SingleElementSymbol)outputColumns.get(i);
                    String shortName = symbol.getShortName();
                    for (int j = 0; j < topCols.size(); ++j) {
                        SingleElementSymbol topCol = (SingleElementSymbol)topCols.get(j);
                        if (!shortName.equalsIgnoreCase(topCol.getShortName())) continue;
                        unfilteredIndices[i] = j;
                        break;
                    }
                    if (unfilteredIndices[i] != -1) continue;
                    Assertion.failed((String)QueryExecPlugin.Util.getString("ERR.015.004.0058", (Object)shortName));
                }
            }
        }
        ArrayList firstProjColumns = null;
        for (i = 0; i < allProjects.size(); ++i) {
            PlanNode projectNode = (PlanNode)allProjects.get(i);
            List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
            ArrayList newCols = new ArrayList();
            for (int j = 0; j < unfilteredIndices.length; ++j) {
                newCols.add(projectCols.get(unfilteredIndices[j]));
            }
            projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, newCols);
            if (i != 0) continue;
            firstProjColumns = newCols;
        }
        if (sourceNode.hasBooleanProperty((Object)NodeConstants.Info.INLINE_VIEW)) {
            firstProjColumns.clear();
            Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
            for (SingleElementSymbol column : outputColumns) {
                SingleElementSymbol outputColumn;
                Expression expression = (Expression)symbolMap.get(column);
                if (!(expression instanceof SingleElementSymbol)) {
                    expression = new ExpressionSymbol(column.getShortName(), expression);
                }
                if (!(expression instanceof AliasSymbol || !((outputColumn = (SingleElementSymbol)expression) instanceof ExpressionSymbol) && outputColumn.getShortCanonicalName().equals(column.getShortCanonicalName()))) {
                    expression = new AliasSymbol(column.getShortName(), outputColumn);
                }
                firstProjColumns.add(expression);
            }
        }
        return firstProjColumns;
    }

    boolean hasDupRemoval(PlanNode node) {
        int nodeType = node.getType();
        if (nodeType == 19 || nodeType == 7) {
            return false;
        }
        if (nodeType == 5 || nodeType == 17 && node.getFirstChild() != null && node.getFirstChild().getType() == 5) {
            return true;
        }
        if (nodeType == 29 && node.getProperty((Object)NodeConstants.Info.SET_OPERATION).equals(new Integer(0)) && node.getProperty((Object)NodeConstants.Info.USE_ALL).equals(Boolean.FALSE)) {
            return true;
        }
        if (node.getChildCount() > 0) {
            for (PlanNode childNode : node.getChildren()) {
                boolean childHasNoAll = this.hasDupRemoval(childNode);
                if (!childHasNoAll) continue;
                return true;
            }
        }
        return false;
    }

    List findTopCols(PlanNode node, Integer nodeProperty) {
        List topCols = null;
        for (PlanNode tempNode = node; tempNode != null && (topCols = (List)tempNode.getProperty((Object)nodeProperty)) == null && tempNode.getChildCount() > 0; tempNode = tempNode.getFirstChild()) {
        }
        return topCols;
    }

    /*
     * WARNING - void declaration
     */
    void collectRequiredInputSymbols(PlanNode node, Collection requiredSymbols, Set createdSymbols) {
        ArrayList<Object> requiredSymbolsList = new ArrayList<Object>();
        switch (node.getType()) {
            case 11: {
                List projectCols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                for (SingleElementSymbol singleElementSymbol : projectCols) {
                    if (this.symbolCreatedHere(node, singleElementSymbol)) {
                        void var7_7;
                        createdSymbols.add(singleElementSymbol);
                        if (singleElementSymbol instanceof AliasSymbol) {
                            SingleElementSymbol singleElementSymbol2 = ((AliasSymbol)singleElementSymbol).getSymbol();
                        }
                        if (this.symbolCreatedHere(node, (SingleElementSymbol)var7_7)) {
                            createdSymbols.add(var7_7);
                            Expression expression = ((ExpressionSymbol)var7_7).getExpression();
                            AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(requiredSymbolsList, requiredSymbolsList);
                            AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
                            expression.acceptVisitor((LanguageVisitor)nav);
                            continue;
                        }
                        requiredSymbolsList.add(var7_7);
                        continue;
                    }
                    requiredSymbolsList.add(singleElementSymbol);
                }
                break;
            }
            case 13: {
                Criteria selectCriteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                Boolean isHaving = (Boolean)node.getProperty((Object)NodeConstants.Info.IS_HAVING);
                if (isHaving != null && isHaving.equals(Boolean.TRUE)) {
                    AggregateSymbolCollectorVisitor aggregateSymbolCollectorVisitor = new AggregateSymbolCollectorVisitor(requiredSymbolsList, requiredSymbolsList);
                    AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)aggregateSymbolCollectorVisitor);
                    selectCriteria.acceptVisitor((LanguageVisitor)nav);
                    break;
                }
                ElementCollectorVisitor.getElements((LanguageObject)selectCriteria, requiredSymbolsList);
                break;
            }
            case 7: {
                List list = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                if (list == null) break;
                for (Criteria joinCriteria : list) {
                    ElementCollectorVisitor.getElements((LanguageObject)joinCriteria, requiredSymbolsList);
                }
                break;
            }
            case 5: 
            case 17: 
            case 41: {
                requiredSymbolsList.addAll((List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
                break;
            }
            case 23: {
                List groupCols = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                if (groupCols != null) {
                    for (Object symbol : groupCols) {
                        if (symbol instanceof ElementSymbol) {
                            requiredSymbolsList.add(symbol);
                            continue;
                        }
                        ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
                        Expression expr = exprSymbol.getExpression();
                        ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbolsList);
                        createdSymbols.add(exprSymbol);
                    }
                }
                ArrayList aggregateCols = (ArrayList)node.getProperty((Object)NodeConstants.Info.AGGREGATES);
                List outputCols = (List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
                for (Object outputSymbol : outputCols) {
                    if (!(outputSymbol instanceof AggregateSymbol)) continue;
                    if (aggregateCols == null) {
                        aggregateCols = new ArrayList();
                        node.setProperty((Object)NodeConstants.Info.AGGREGATES, aggregateCols);
                    }
                    aggregateCols.add(outputSymbol);
                }
                if (aggregateCols == null) break;
                createdSymbols.addAll(aggregateCols);
                for (AggregateSymbol agg : aggregateCols) {
                    Expression aggExpr = agg.getExpression();
                    if (aggExpr == null) continue;
                    if (aggExpr instanceof AggregateSymbol) {
                        requiredSymbolsList.add(aggExpr);
                        continue;
                    }
                    ElementCollectorVisitor.getElements((LanguageObject)aggExpr, requiredSymbolsList);
                }
                break;
            }
        }
        List refs = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs != null) {
            for (Reference reference : refs) {
                Expression expr = reference.getExpression();
                ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbolsList);
            }
        }
        if (node.getType() == 5 || node.getType() == 41 || node.getType() == 17) {
            requiredSymbols.addAll(requiredSymbolsList);
        } else {
            for (Object e : requiredSymbolsList) {
                if (requiredSymbols.contains(e)) continue;
                requiredSymbols.add(e);
            }
        }
    }

    public static List reverseSymbolLookup(List inputList, Map symbolMap) {
        ArrayList result = new ArrayList(inputList.size());
        HashMap reverseMap = new HashMap(symbolMap.size());
        HashMap shortNameMap = new HashMap(symbolMap.size());
        for (Map.Entry entry : symbolMap.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
            shortNameMap.put(((SingleElementSymbol)entry.getKey()).getShortCanonicalName(), entry.getKey());
        }
        for (Expression projCol : inputList) {
            Object value = reverseMap.get(projCol);
            if (value == null) {
                AliasSymbol aliasSymbol;
                if (projCol instanceof ExpressionSymbol && !(projCol instanceof AggregateSymbol)) {
                    projCol = ((ExpressionSymbol)projCol).getExpression();
                } else if (projCol instanceof AliasSymbol && (value = shortNameMap.get((aliasSymbol = (AliasSymbol)projCol).getCanonicalName())) == null) {
                    projCol = aliasSymbol.getSymbol();
                }
            }
            if (value == null) {
                value = reverseMap.get(projCol);
            }
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    boolean symbolCreatedHere(PlanNode node, SingleElementSymbol symbol) {
        if (symbol instanceof ElementSymbol || symbol instanceof AggregateSymbol) {
            return false;
        }
        if (node.getChildCount() == 0) {
            return true;
        }
        node = node.getFirstChild();
        while (true) {
            switch (node.getType()) {
                case 3: {
                    Collection exprCreated = (Collection)node.getProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED);
                    if (exprCreated != null) {
                        return !exprCreated.contains(symbol);
                    }
                    return true;
                }
                case 23: {
                    List groupElements = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                    if (groupElements != null) {
                        return !groupElements.contains(symbol);
                    }
                    return true;
                }
                case 5: 
                case 13: 
                case 17: {
                    break;
                }
                default: {
                    return true;
                }
            }
            node = node.getFirstChild();
        }
    }

    List collectFilteredElements(Collection sourceElements, Collection filterGroups) {
        ArrayList<SingleElementSymbol> targetElements = new ArrayList<SingleElementSymbol>();
        if (sourceElements == null) {
            return targetElements;
        }
        for (SingleElementSymbol element : sourceElements) {
            Expression expr;
            if (element instanceof ElementSymbol) {
                if (!filterGroups.contains(((ElementSymbol)element).getGroupSymbol())) continue;
                targetElements.add(element);
                continue;
            }
            if (element instanceof AggregateSymbol) {
                expr = ((AggregateSymbol)element).getExpression();
                if (expr != null) {
                    Collection aggElem = ElementCollectorVisitor.getElements((LanguageObject)expr, true);
                    for (ElementSymbol elem : aggElem) {
                        if (!filterGroups.contains(elem.getGroupSymbol())) continue;
                        targetElements.add(element);
                    }
                    continue;
                }
                targetElements.add(element);
                continue;
            }
            if (!(element instanceof ExpressionSymbol) || !filterGroups.containsAll(GroupsUsedByElementsVisitor.getGroups((LanguageObject)(expr = ((ExpressionSymbol)element).getExpression())))) continue;
            targetElements.add(element);
        }
        return targetElements;
    }

    public String toString() {
        return "AssignOutputElements";
    }
}

