/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache.connector;

import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.GlobalConnectorCapabilitiesProvider;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.connector.CacheConnection;

public class CacheConnector
implements Connector,
XAConnector,
GlobalConnectorCapabilitiesProvider {
    private Connector actualConnector;
    private ResultSetCache cache;

    public CacheConnector(Connector actualConnector, ResultSetCache cache) {
        this.actualConnector = actualConnector;
        this.cache = cache;
    }

    public void initialize(ConnectorEnvironment environment) throws ConnectorException {
        this.actualConnector.initialize(environment);
    }

    public void start() throws ConnectorException {
        this.actualConnector.start();
    }

    public void stop() {
        this.actualConnector.stop();
    }

    public Connection getConnection(SecurityContext context) throws ConnectorException {
        return new CacheConnection(this.actualConnector.getConnection(context), this.cache);
    }

    public ResultSetCache getCache() {
        return this.cache;
    }

    public Connection getXAConnection(SecurityContext securityContext, TransactionContext transactionContext) throws ConnectorException {
        if (this.actualConnector instanceof XAConnector) {
            return ((XAConnector)this.actualConnector).getXAConnection(securityContext, transactionContext);
        }
        return null;
    }

    public ConnectorCapabilities getCapabilities() throws ConnectorException {
        if (this.actualConnector instanceof GlobalConnectorCapabilitiesProvider) {
            return ((GlobalConnectorCapabilitiesProvider)this.actualConnector).getCapabilities();
        }
        return null;
    }
}

