/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceElement;
import com.metamatrix.dqp.service.AuthorizationService;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitorUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.lang.XQuery;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AuthorizationValidationVisitor
extends AbstractValidationVisitor {
    public static final String GET_UPDATED_CHARACTER_VDB_RESOURCE = "System.getUpdatedCharacterVDBResource";
    private static Set globallyAccessibleProcedures = new HashSet();
    private String connectionID;
    private AuthorizationService authInterface;

    public AuthorizationValidationVisitor(String connectionID, AuthorizationService authInterface) {
        this.connectionID = connectionID;
        this.authInterface = authInterface;
    }

    public void visit(Delete obj) {
        this.validateEntitlements(obj);
    }

    public void visit(Insert obj) {
        this.validateEntitlements(obj);
    }

    public void visit(Query obj) {
        this.validateEntitlements(obj);
    }

    public void visit(Update obj) {
        this.validateEntitlements(obj);
    }

    public void visit(StoredProcedure obj) {
        this.validateEntitlements(obj);
    }

    public void visit(XQuery obj) {
        if (this.authInterface.disableXQuery()) {
            this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.connectionID, this.getActionLabel(0)}), (LanguageObject)obj);
        }
    }

    public void visit(Function obj) {
        if ("lookup".equalsIgnoreCase(obj.getName())) {
            try {
                LinkedList<Object> symbols = new LinkedList<Object>();
                ResolverVisitorUtil.ResolvedLookup lookup = ResolverVisitorUtil.resolveLookup(obj, this.getMetadata());
                symbols.add(lookup.getGroup());
                symbols.add(lookup.getKeyElement());
                symbols.add(lookup.getReturnElement());
                this.validateEntitlements(symbols, 0, 0);
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
            catch (MetaMatrixProcessingException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
        }
    }

    protected void validateEntitlements(Insert obj) {
        this.validateEntitlements(obj.getVariables(), 1, 1);
    }

    protected void validateEntitlements(Update obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), 0, 2);
        }
        HashSet changeVars = new HashSet();
        for (CompareCriteria crit : obj.getChangeList()) {
            ElementCollectorVisitor.getElements((LanguageObject)crit, changeVars);
        }
        this.validateEntitlements(changeVars, 2, 2);
    }

    protected void validateEntitlements(Delete obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), 0, 3);
        }
        HashSet<GroupSymbol> deleteVars = new HashSet<GroupSymbol>();
        deleteVars.add(obj.getGroup());
        this.validateEntitlements(deleteVars, 3, 3);
    }

    protected void validateEntitlements(Query obj) {
        Into intoObj = obj.getInto();
        if (intoObj != null) {
            GroupSymbol intoGroup = intoObj.getGroup();
            List intoElements = null;
            try {
                intoElements = ResolverUtil.resolveElementsInGroup(intoGroup, this.getMetadata());
            }
            catch (QueryMetadataException err) {
                this.handleException((MetaMatrixException)((Object)err), (LanguageObject)intoGroup);
            }
            catch (QueryResolverException err) {
                this.handleException((MetaMatrixException)((Object)err), (LanguageObject)intoGroup);
            }
            catch (MetaMatrixComponentException err) {
                this.handleException((MetaMatrixException)((Object)err), (LanguageObject)intoGroup);
            }
            this.validateEntitlements(intoElements, 1, 1);
        }
        Collection entitledObjects = GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true);
        if (!this.isXMLCommand((Command)obj)) {
            entitledObjects.addAll(ElementCollectorVisitor.getElements((LanguageObject)obj, true));
        }
        if (entitledObjects.size() == 0) {
            return;
        }
        this.validateEntitlements(entitledObjects, 0, 0);
    }

    public static void addGloballyAccessibleProcedure(String name) {
        globallyAccessibleProcedures.add(name);
    }

    public static void removeGloballyAccessibleProcedure(String name) {
        globallyAccessibleProcedures.remove(name);
    }

    protected void validateEntitlements(StoredProcedure obj) {
        if (globallyAccessibleProcedures.contains(obj.getProcedureName())) {
            return;
        }
        ArrayList<GroupSymbol> symbols = new ArrayList<GroupSymbol>(1);
        symbols.add(obj.getGroup());
        this.validateEntitlements(symbols, 0, 4);
    }

    private String getActionLabel(int actionCode) {
        switch (actionCode) {
            case 0: {
                return "Read";
            }
            case 1: {
                return "Create";
            }
            case 2: {
                return "Update";
            }
            case 3: {
                return "Delete";
            }
        }
        return "UNKNOWN";
    }

    protected void validateEntitlements(Collection symbols, int actionCode, int auditContext) {
        HashMap nameToSymbolMap = new HashMap();
        for (Object symbol : symbols) {
            try {
                GroupSymbol group;
                String fullName = null;
                Object metadataID = null;
                if (symbol instanceof ElementSymbol ? (metadataID = ((ElementSymbol)symbol).getMetadataID()) instanceof MultiSourceElement || metadataID instanceof TempMetadataID : symbol instanceof GroupSymbol && (metadataID = (group = (GroupSymbol)symbol).getMetadataID()) instanceof TempMetadataID && !group.isProcedure()) continue;
                fullName = this.getMetadata().getFullName(metadataID);
                nameToSymbolMap.put(fullName, symbol);
            }
            catch (QueryMetadataException e) {
                this.handleException((MetaMatrixException)((Object)e));
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e));
            }
        }
        if (!nameToSymbolMap.isEmpty()) {
            try {
                Collection inaccessibleResources = this.authInterface.getInaccessibleResources(this.connectionID, actionCode, nameToSymbolMap.keySet(), auditContext);
                if (inaccessibleResources.size() > 0) {
                    ArrayList inaccessibleSymbols = new ArrayList(inaccessibleResources.size());
                    for (String name : inaccessibleResources) {
                        inaccessibleSymbols.add(nameToSymbolMap.get(name));
                    }
                    this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.connectionID, this.getActionLabel(actionCode)}), inaccessibleSymbols);
                }
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e));
            }
        }
    }

    static {
        globallyAccessibleProcedures.add(GET_UPDATED_CHARACTER_VDB_RESOURCE);
    }
}

