/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.jms;

import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.jms.JMSXMLConnectorState;
import com.metamatrix.connector.xml.jms.Messages;
import com.metamatrix.connector.xml.soap.SOAPConnectorStateImpl;
import com.metamatrix.connector.xmlsource.soap.SecurityToken;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Map;
import java.util.Properties;

public class JMSSOAPConnectorState
extends JMSXMLConnectorState
implements SOAPConnectorState {
    public static final String AUTH_USER_PROPERTY_NAME = "AuthUserName";
    public static final String AUTH_PASSWORD_PROPERTY_NAME = "AuthPassword";
    SOAPConnectorStateImpl soapState = new SOAPConnectorStateImpl();
    private boolean m_useBasicAuth;
    private boolean m_useWSSec;
    private String m_authUser;
    private String m_authPassword;
    public static final String AUTH_REGIME_WSSEC = "WS-Security";
    public static final String AUTH_REGIME_BASIC = "SOAP-BASIC";
    public static final String AUTH_REGIME_NONE = "None";
    public static final String AUTH_REGIME_PROPERTY_NAME = "AuthRegime";

    public JMSSOAPConnectorState() {
        this.setUseBasicAuth(false);
        this.setUseWSSec(false);
        this.setAuthUser(new String());
        this.setAuthPassword(new String());
    }

    public void setState(ConnectorEnvironment env) throws ConnectorException {
        super.setState(env);
        this.soapState.setState(env);
        Properties props = env.getProperties();
        String authRegime = props.getProperty(AUTH_REGIME_PROPERTY_NAME);
        boolean useAuth = false;
        if (this.isNotNullOrEmpty(authRegime)) {
            if (authRegime.equals(AUTH_REGIME_NONE)) {
                this.setUseBasicAuth(false);
                this.setUseWSSec(false);
            } else if (authRegime.equals(AUTH_REGIME_BASIC)) {
                this.setUseBasicAuth(true);
                this.setUseWSSec(false);
                useAuth = true;
            } else if (authRegime.equals(AUTH_REGIME_WSSEC)) {
                this.setUseBasicAuth(false);
                this.setUseWSSec(true);
                useAuth = true;
            }
        } else {
            this.setUseBasicAuth(false);
            this.setUseWSSec(false);
        }
        if (useAuth) {
            String user = props.getProperty(AUTH_USER_PROPERTY_NAME);
            if (!this.isNotNullOrEmpty(user)) {
                throw new ConnectorException(Messages.getString((String)"SOAPConnectorStateImpl.empty.AUTH_USER_PROPERTY_NAME"));
            }
            this.setAuthUser(user);
            String pwd = props.getProperty(AUTH_PASSWORD_PROPERTY_NAME);
            if (this.isNotNullOrEmpty(pwd)) {
                this.setAuthPassword(pwd);
            } else {
                throw new ConnectorException(Messages.getString((String)"SOAPConnectorStateImpl.empty.AUTH_PASSWORD_PROPERTY_NAME"));
            }
        }
    }

    public Properties getState() {
        Properties props = super.getState();
        props.putAll((Map<?, ?>)this.soapState.getState());
        props.setProperty(AUTH_REGIME_PROPERTY_NAME, Boolean.toString(this.isUseBasicAuth()));
        props.setProperty(AUTH_USER_PROPERTY_NAME, this.getAuthUser());
        props.setProperty(AUTH_PASSWORD_PROPERTY_NAME, this.getAuthPassword());
        return props;
    }

    public void setLogger(ConnectorLogger logger) {
        super.setLogger(logger);
        this.soapState.setLogger(logger);
    }

    public boolean isEncoded() {
        return this.soapState.isEncoded();
    }

    public boolean isRPC() {
        return this.soapState.isRPC();
    }

    private void setUseBasicAuth(boolean basicAuth) {
        this.m_useBasicAuth = basicAuth;
    }

    public boolean isUseBasicAuth() {
        return this.m_useBasicAuth;
    }

    private void setUseWSSec(boolean wsSec) {
        this.m_useWSSec = wsSec;
    }

    public boolean isUseWSSec() {
        return this.m_useWSSec;
    }

    private void setAuthUser(String authUser) {
        this.m_authUser = authUser;
    }

    public String getAuthUser() {
        return this.m_authUser;
    }

    public String getAuthPassword() {
        return this.m_authPassword;
    }

    public void setAuthPassword(String password) {
        this.m_authPassword = password;
    }

    public boolean isExceptionOnFault() {
        return this.soapState.isExceptionOnFault();
    }

    public boolean isUseHttpChunking() {
        return this.soapState.isUseHttpChunking();
    }

    public SecurityToken getSecurityToken() {
        return null;
    }
}

